/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.tools.wizards.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.internal.tools.Messages;
import org.eclipse.e4.internal.tools.wizards.model.BaseApplicationModelWizard;
import org.eclipse.e4.internal.tools.wizards.model.NewModelFilePage;
import org.eclipse.e4.ui.model.fragment.MFragmentFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundlePluginModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NewContributionModelWizard
extends BaseApplicationModelWizard {
    private static final String MODEL_FRAGMENT_HEADER = "Model-Fragment";

    @Override
    public String getDefaultFileName() {
        return "fragment.e4xmi";
    }

    @Override
    protected EObject createInitialModel() {
        return (EObject)MFragmentFactory.INSTANCE.createModelFragments();
    }

    @Override
    protected NewModelFilePage createWizardPage(ISelection selection) {
        return new NewContributionModelFilePage(selection, this.getDefaultFileName());
    }

    @Override
    protected void adjustDependencies(IFile file) {
        super.adjustFragmentDependencies(file);
    }

    @Override
    protected void registerWithExtensionPointIfRequired(IProject project, WorkspaceBundlePluginModel fModel, IFile file) throws CoreException {
        NewContributionModelFilePage page = (NewContributionModelFilePage)this.getPage("wizardPage");
        if (page.mode == ContributionMode.DYNAMIC) {
            IBundle bundle = fModel.getBundleModel().getBundle();
            bundle.setHeader(MODEL_FRAGMENT_HEADER, file.getName());
            fModel.save();
        } else {
            super.registerWithExtensionPointIfRequired(project, fModel, file);
        }
    }

    private static enum ContributionMode {
        STATIC(Messages.ContributionMode_Static, Messages.ContributionMode_Static_Info),
        DYNAMIC(Messages.ContributionMode_Dynamic, Messages.ContributionMode_Dynamic_Info);

        private final String label;
        private final String description;

        private ContributionMode(String label, String description) {
            this.label = label;
            this.description = description;
        }

        public String toString() {
            return this.label;
        }

        String getDescription() {
            return this.description;
        }
    }

    private static final class NewContributionModelFilePage
    extends NewModelFilePage {
        ContributionMode mode = ContributionMode.STATIC;

        public NewContributionModelFilePage(ISelection selection, String defaultFilename) {
            super(selection, defaultFilename);
        }

        @Override
        protected void createAdditionalControls(Composite parent) {
            Button button;
            Label label = new Label(parent, 0);
            label.setText(Messages.ContributionMode);
            ContributionMode[] values = ContributionMode.values();
            Button[] buttons = new Button[values.length];
            Composite buttonParent = new Composite(parent, 0);
            buttonParent.setLayout((Layout)new GridLayout(values.length, false));
            int i = 0;
            while (i < values.length) {
                ContributionMode mode = values[i];
                button = buttons[i] = new Button(buttonParent, 16);
                button.setSelection(this.mode == mode);
                button.setData((Object)mode);
                button.setText(mode.toString());
                ++i;
            }
            new Label(parent, 0);
            new Label(parent, 0);
            final Label modeDescriptionLabel = new Label(parent, 0);
            modeDescriptionLabel.setText(this.mode.getDescription());
            GridData modeDescriptionLabelLayoutData = new GridData(1808);
            modeDescriptionLabelLayoutData.horizontalSpan = 2;
            modeDescriptionLabel.setLayoutData((Object)modeDescriptionLabelLayoutData);
            Button[] buttonArray = buttons;
            int n = buttons.length;
            int n2 = 0;
            while (n2 < n) {
                button = buttonArray[n2];
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (button.getSelection()) {
                            ContributionMode mode;
                            mode = mode = (ContributionMode)((Object)button.getData());
                            modeDescriptionLabel.setText(mode.getDescription());
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                ++n2;
            }
        }
    }
}

