/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotationPropertyContainer;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;
import org.eclipse.jst.ws.jaxws.utils.annotations.IValue;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.AnnotationProperty;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.AttributeTypeEnum;

public class AnnotationPropertyContainer
implements IAnnotationPropertyContainer {
    private Map<String, Set<IParamValuePair>> typeAnnotationName2ParamValuesMap = new HashMap<String, Set<IParamValuePair>>();
    private Map<String, Set<IParamValuePair>> methodAnnotationName2ParamValuesMap = new HashMap<String, Set<IParamValuePair>>();
    private Map<String, Set<IParamValuePair>> parameterAnnotationName2ParamValuesMap = new HashMap<String, Set<IParamValuePair>>();

    @Override
    public void addAnnotationProperty(AnnotationProperty annotationProperty, ElementType target) {
        Set<IParamValuePair> paramValuesSet;
        if (annotationProperty == null) {
            throw new NullPointerException("annotationProperty could not be null!");
        }
        if (target == null) {
            throw new NullPointerException("target could not be null!");
        }
        if (!(target.equals((Object)ElementType.TYPE) || target.equals((Object)ElementType.METHOD) || target.equals((Object)ElementType.PARAMETER))) {
            throw new IllegalArgumentException("target parameter is not of correct type");
        }
        Map<String, Set<IParamValuePair>> annotationName2ParamValuesMap = null;
        if (target.equals((Object)ElementType.TYPE)) {
            annotationName2ParamValuesMap = this.typeAnnotationName2ParamValuesMap;
        }
        if (target.equals((Object)ElementType.METHOD)) {
            annotationName2ParamValuesMap = this.methodAnnotationName2ParamValuesMap;
        }
        if (target.equals((Object)ElementType.PARAMETER)) {
            annotationName2ParamValuesMap = this.parameterAnnotationName2ParamValuesMap;
        }
        if ((paramValuesSet = annotationName2ParamValuesMap.get(annotationProperty.getAnnotationName())) == null) {
            paramValuesSet = new HashSet<IParamValuePair>();
            annotationName2ParamValuesMap.put(annotationProperty.getAnnotationName(), paramValuesSet);
        }
        IValue value = null;
        if (annotationProperty.getAttributeType() == null) {
            return;
        }
        if (annotationProperty.getAttributeType().equals((Object)AttributeTypeEnum.BOOLEAN)) {
            value = AnnotationFactory.createBooleanValue(new Boolean(annotationProperty.getValue()));
        }
        annotationProperty.getAttributeType().equals((Object)AttributeTypeEnum.CLASS);
        if (annotationProperty.getAttributeType().equals((Object)AttributeTypeEnum.INTEGER)) {
            value = AnnotationFactory.createIntegerValue(annotationProperty.getValue());
        }
        if (annotationProperty.getAttributeType().equals((Object)AttributeTypeEnum.QUALIFIED_NAME)) {
            value = AnnotationFactory.createQualifiedNameValue(annotationProperty.getValue());
        }
        if (value == null) {
            value = AnnotationFactory.createStringValue(annotationProperty.getValue());
        }
        IParamValuePair paramValuePair = AnnotationFactory.createParamValuePairValue(annotationProperty.getAttributeName(), value);
        paramValuesSet.add(paramValuePair);
    }

    @Override
    public Set<IAnnotation<ITypeParameter>> getParameterAnnotations(ITypeParameter tParam) {
        return this.getAnnotations(ElementType.PARAMETER, tParam);
    }

    @Override
    public Set<IAnnotation<IType>> getTypeAnnotations(IType type) {
        return this.getAnnotations(ElementType.TYPE, type);
    }

    @Override
    public Set<IAnnotation<IMethod>> getMethodAnnotations(IMethod method) {
        return this.getAnnotations(ElementType.METHOD, method);
    }

    private <T extends IJavaElement> Set<IAnnotation<T>> getAnnotations(ElementType target, T iTarget) {
        if (!(target.equals((Object)ElementType.TYPE) || target.equals((Object)ElementType.METHOD) || target.equals((Object)ElementType.PARAMETER))) {
            throw new IllegalArgumentException("target parameter is not of correct type");
        }
        Map<String, Set<IParamValuePair>> annotationName2ParamValuesMap = null;
        if (target.equals((Object)ElementType.TYPE)) {
            annotationName2ParamValuesMap = this.typeAnnotationName2ParamValuesMap;
        }
        if (target.equals((Object)ElementType.METHOD)) {
            annotationName2ParamValuesMap = this.methodAnnotationName2ParamValuesMap;
        }
        if (target.equals((Object)ElementType.PARAMETER)) {
            annotationName2ParamValuesMap = this.parameterAnnotationName2ParamValuesMap;
        }
        HashSet<IAnnotation<T>> result = new HashSet<IAnnotation<T>>();
        Set<String> keys = annotationName2ParamValuesMap.keySet();
        for (String key : keys) {
            Set<IParamValuePair> paramValuePairsSet = annotationName2ParamValuesMap.get(key);
            IAnnotation<T> annotation = AnnotationFactory.createAnnotation(key, paramValuePairsSet, iTarget);
            result.add(annotation);
        }
        return result;
    }
}

