/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.tableedit;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.jst.pagedesigner.editpolicies.ITableEditAdapter;
import org.eclipse.jst.pagedesigner.tableedit.MarqueeRectangleFigure;
import org.eclipse.jst.pagedesigner.tableedit.TableEditHelper;
import org.eclipse.jst.pagedesigner.tableedit.TableResizeRequest;

public class TableSideResizeDragTracker
extends DragEditPartsTracker {
    private boolean _isrow;
    private int _index;
    private MarqueeRectangleFigure _marqueeFigure;

    public TableSideResizeDragTracker(EditPart sourceEditPart, boolean isrow, int index) {
        super(sourceEditPart);
        this._isrow = isrow;
        this._index = index;
    }

    protected void showSourceFeedback() {
        Rectangle rect = this.getFeedbackRect();
        if (rect != null) {
            rect = rect.getCopy();
            this.getMarqueeRectangleFigure().setBounds(rect);
        }
    }

    private int calculateDelta() {
        int delta = this._isrow ? this.getLocation().y - this.getStartLocation().y : this.getLocation().x - this.getStartLocation().x;
        return delta;
    }

    private Rectangle getFeedbackRect() {
        Rectangle rect;
        ITableEditAdapter adapter = this.getTableEditAdapter();
        if (adapter == null) {
            return null;
        }
        IFigure figure = ((GraphicalEditPart)this.getSourceEditPart()).getFigure();
        Rectangle bounds = figure.getBounds();
        Insets insets = figure.getInsets();
        if (this._isrow) {
            int delta = this.calculateDelta();
            rect = new Rectangle(0, adapter.getRowResizeStart(this._index) + delta, bounds.width - insets.getWidth(), adapter.getRowResizeWidth());
        } else {
            int delta = this.calculateDelta();
            rect = new Rectangle(adapter.getColumnResizeStart(this._index) + delta, 0, adapter.getColumnResizeWidth(), bounds.height - insets.getHeight());
        }
        rect.translate(bounds.x + insets.left, bounds.y + insets.top);
        figure.translateToAbsolute((Translatable)rect);
        this.getMarqueeRectangleFigure().translateToRelative((Translatable)rect);
        return rect;
    }

    private ITableEditAdapter getTableEditAdapter() {
        return TableEditHelper.getTableEditAdapter((GraphicalEditPart)this.getSourceEditPart());
    }

    protected void eraseSourceFeedback() {
        super.eraseSourceFeedback();
        if (this._marqueeFigure != null) {
            this.removeFeedback((IFigure)this._marqueeFigure);
            this._marqueeFigure = null;
        }
    }

    private MarqueeRectangleFigure getMarqueeRectangleFigure() {
        if (this._marqueeFigure == null) {
            this._marqueeFigure = new MarqueeRectangleFigure();
            this.addFeedback((IFigure)this._marqueeFigure);
        }
        return this._marqueeFigure;
    }

    protected Request createTargetRequest() {
        return new TableResizeRequest(this._isrow, this._index);
    }

    protected boolean handleButtonDown(int button) {
        this.lockTargetEditPart(this.getSourceEditPart());
        return super.handleButtonDown(button);
    }

    protected Command getCommand() {
        return this.getTargetEditPart().getCommand((Request)this.getTargetRequest());
    }
}

