/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.itemcreation.command;

import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.itemcreation.command.ContainerCreationCommand;
import org.eclipse.jst.pagedesigner.utils.BodyHelper;
import org.eclipse.jst.pagedesigner.validation.caret.JSFRootContainerPositionRule;
import org.w3c.dom.Document;

public final class SingletonContainerCreationCommand
extends ContainerCreationCommand {
    private static final int MAX_DEPTH_TO_SEARCH_FOR_CONTAINER = 10;

    public SingletonContainerCreationCommand(IDOMPosition domPosition, TagIdentifier containerTag, TagIdentifier tagBeingCreated) {
        super(domPosition, containerTag, tagBeingCreated);
    }

    @Override
    protected IDOMPosition doExecute() {
        return this.insertSingletonIfNotPresent();
    }

    private IDOMPosition insertSingletonIfNotPresent() {
        IDOMPosition domPosition = this.getDomPosition();
        TagIdentifier containerTag = this.getContainerTag();
        TagIdentifier tagBeingCreated = this.getTagBeingCreated();
        Document document = EditModelQuery.getDocumentNode(domPosition.getContainerNode());
        boolean isContainerAlreadyPresent = JSFRootContainerPositionRule.hasBasicContainers(document, 10);
        if (isContainerAlreadyPresent) {
            if (containerTag.equals((Object)tagBeingCreated)) {
                domPosition = null;
            }
        } else if (!containerTag.equals((Object)tagBeingCreated)) {
            domPosition = BodyHelper.insertBody(domPosition, containerTag.asQName(), "f");
        }
        return domPosition;
    }

    @Override
    protected boolean prepare() {
        throw new UnsupportedOperationException("don't use");
    }
}

