/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.html;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.CommandResources;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.dom.DOMStyleUtil;
import org.eclipse.jst.pagedesigner.dom.html.TableUtil;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Element;

public class TableResizeRowCommand
extends DesignerCommand {
    private Element _table;
    private int _rowIndex;
    private int _delta;

    public TableResizeRowCommand(IHTMLGraphicalViewer viewer, Element table, int rowIndex, int delta) {
        super(CommandResources.getString("TableResizeRowCommand.Label.ResizeColumn"), viewer);
        this._table = table;
        this._rowIndex = rowIndex;
        this._delta = delta;
    }

    @Override
    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._table);
    }

    @Override
    protected void doExecute() {
        int index = this._rowIndex - 1;
        if (index < 0) {
            index = 0;
        }
        int domIndex = index;
        ArrayList list = new ArrayList();
        TableUtil.getTrElements(this._table, list);
        Element tr = (Element)list.get(domIndex);
        IFigure cellFigure = this.getFigureInfo(tr);
        int oldRowHeight = cellFigure.getBounds().height;
        int cellPadding = cellFigure.getInsets().getHeight();
        int newHeight = oldRowHeight + this._delta - cellPadding;
        if (this._rowIndex - 1 < 0) {
            newHeight = oldRowHeight - this._delta - cellPadding;
        }
        HashMap<String, CallSite> map = new HashMap<String, CallSite>();
        if (newHeight > 0) {
            map.put("height", (CallSite)((Object)(newHeight + "px")));
            DOMStyleUtil.insertStyle(tr, map);
        }
    }
}

