/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import java.util.Arrays;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotationStringArrayExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.IndexedConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedExpressionConverter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTypeAnnotation;

public final class SourceXmlTypeAnnotation
extends SourceAnnotation
implements XmlTypeAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.XmlType");
    private static final DeclarationAnnotationElementAdapter<String> FACTORY_CLASS_ADAPTER = SourceXmlTypeAnnotation.buildFactoryClassAdapter();
    private final AnnotationElementAdapter<String> factoryClassAdapter;
    private String factoryClass;
    private TextRange factoryClassTextRange;
    private String fullyQualifiedFactoryClassName;
    private static final DeclarationAnnotationElementAdapter<String> FACTORY_METHOD_ADAPTER = SourceXmlTypeAnnotation.buildFactoryMethodAdapter();
    private final AnnotationElementAdapter<String> factoryMethodAdapter;
    private String factoryMethod;
    private TextRange factoryMethodTextRange;
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = SourceXmlTypeAnnotation.buildNameAdapter();
    private final AnnotationElementAdapter<String> nameAdapter;
    private String name;
    private TextRange nameTextRange;
    private TextRange nameValidationTextRange;
    private static final DeclarationAnnotationElementAdapter<String> NAMESPACE_ADAPTER = SourceXmlTypeAnnotation.buildNamespaceAdapter();
    private final AnnotationElementAdapter<String> namespaceAdapter;
    private String namespace;
    private TextRange namespaceTextRange;
    private TextRange namespaceValidationTextRange;
    private final IndexedDeclarationAnnotationElementAdapter<String> propOrderDeclarationAdapter;
    private final AnnotationElementAdapter<String[]> propOrderAdapter;
    private final Vector<String> propOrder = new Vector();
    private TextRange propOrderTextRange;
    private final Vector<TextRange> propTextRanges = new Vector();

    public SourceXmlTypeAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement) {
        super((JavaResourceModel)parent, annotatedElement, DECLARATION_ANNOTATION_ADAPTER);
        this.factoryClassAdapter = this.buildAnnotationElementAdapter(FACTORY_CLASS_ADAPTER);
        this.factoryMethodAdapter = this.buildAnnotationElementAdapter(FACTORY_METHOD_ADAPTER);
        this.nameAdapter = this.buildAnnotationElementAdapter(NAME_ADAPTER);
        this.namespaceAdapter = this.buildAnnotationElementAdapter(NAMESPACE_ADAPTER);
        this.propOrderDeclarationAdapter = SourceXmlTypeAnnotation.buildArrayAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "propOrder");
        this.propOrderAdapter = this.buildArrayAnnotationElementAdapter((DeclarationAnnotationElementAdapter<String[]>)this.propOrderDeclarationAdapter);
    }

    protected AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    private static IndexedDeclarationAnnotationElementAdapter<String> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return SourceXmlTypeAnnotation.buildArrayAnnotationElementAdapter(annotationAdapter, elementName, (IndexedExpressionConverter<String>)AnnotationStringArrayExpressionConverter.forStrings());
    }

    private static IndexedDeclarationAnnotationElementAdapter<String> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, IndexedExpressionConverter<String> converter) {
        return new IndexedConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    private AnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String[]> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlType";
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.factoryClass = this.buildFactoryClass(astAnnotation);
        this.factoryClassTextRange = this.buildFactoryClassTextRange(astAnnotation);
        this.fullyQualifiedFactoryClassName = this.buildFullyQualifiedFactoryClassName(astAnnotation);
        this.factoryMethod = this.buildFactoryMethod(astAnnotation);
        this.factoryMethodTextRange = this.buildFactoryMethodTextRange(astAnnotation);
        this.name = this.buildName(astAnnotation);
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
        this.nameValidationTextRange = this.buildNameValidationTextRange(astAnnotation);
        this.namespace = this.buildNamespace(astAnnotation);
        this.namespaceTextRange = this.buildNamespaceTextRange(astAnnotation);
        this.namespaceValidationTextRange = this.buildNamespaceValidationTextRange(astAnnotation);
        this.initializePropOrder(astAnnotation);
        this.propOrderTextRange = this.buildPropOrderTextRange(astAnnotation);
        this.syncPropTextRanges(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncFactoryClass(this.buildFactoryClass(astAnnotation));
        this.factoryClassTextRange = this.buildFactoryClassTextRange(astAnnotation);
        this.syncFullyQualifiedFactoryClassName(this.buildFullyQualifiedFactoryClassName(astAnnotation));
        this.syncFactoryMethod(this.buildFactoryMethod(astAnnotation));
        this.factoryMethodTextRange = this.buildFactoryMethodTextRange(astAnnotation);
        this.syncName(this.buildName(astAnnotation));
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
        this.syncNamespace(this.buildNamespace(astAnnotation));
        this.namespaceTextRange = this.buildNamespaceTextRange(astAnnotation);
        this.syncPropOrder(astAnnotation);
        this.propOrderTextRange = this.buildPropOrderTextRange(astAnnotation);
        this.syncPropTextRanges(astAnnotation);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getFactoryClass() {
        return this.factoryClass;
    }

    @Override
    public void setFactoryClass(String factoryClass) {
        if (ObjectTools.notEquals((Object)this.factoryClass, (Object)factoryClass)) {
            this.factoryClass = factoryClass;
            this.factoryClassAdapter.setValue((Object)factoryClass);
        }
    }

    private void syncFactoryClass(String astFactoryClass) {
        String old = this.factoryClass;
        this.factoryClass = astFactoryClass;
        this.firePropertyChanged("factoryClass", old, astFactoryClass);
    }

    private String buildFactoryClass(Annotation astAnnotation) {
        return (String)this.factoryClassAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getFactoryClassTextRange() {
        return this.factoryClassTextRange;
    }

    private TextRange buildFactoryClassTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(FACTORY_CLASS_ADAPTER, astAnnotation);
    }

    @Override
    public String getFullyQualifiedFactoryClassName() {
        return this.fullyQualifiedFactoryClassName;
    }

    private void syncFullyQualifiedFactoryClassName(String name) {
        String old = this.fullyQualifiedFactoryClassName;
        this.fullyQualifiedFactoryClassName = name;
        this.firePropertyChanged("fullyQualifiedFactoryClassName", old, name);
    }

    private String buildFullyQualifiedFactoryClassName(Annotation astAnnotation) {
        return this.factoryClass == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.factoryClassAdapter.getExpression(astAnnotation));
    }

    @Override
    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    @Override
    public void setFactoryMethod(String factoryMethod) {
        if (ObjectTools.notEquals((Object)this.factoryMethod, (Object)factoryMethod)) {
            this.factoryMethod = factoryMethod;
            this.factoryMethodAdapter.setValue((Object)factoryMethod);
        }
    }

    private void syncFactoryMethod(String astFactoryMethod) {
        String old = this.factoryMethod;
        this.factoryMethod = astFactoryMethod;
        this.firePropertyChanged("factoryMethod", old, astFactoryMethod);
    }

    private String buildFactoryMethod(Annotation astAnnotation) {
        return (String)this.factoryMethodAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getFactoryMethodTextRange() {
        return this.factoryMethodTextRange;
    }

    private TextRange buildFactoryMethodTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(FACTORY_METHOD_ADAPTER, astAnnotation);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (ObjectTools.notEquals((Object)this.name, (Object)name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(Annotation astAnnotation) {
        return (String)this.nameAdapter.getValue(astAnnotation);
    }

    private TextRange buildNameTextRange(Annotation astAnnotation) {
        return this.getAnnotationElementTextRange(NAME_ADAPTER, astAnnotation);
    }

    private TextRange buildNameValidationTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(NAME_ADAPTER, astAnnotation);
    }

    @Override
    public TextRange getNameTextRange() {
        return this.nameTextRange;
    }

    @Override
    public TextRange getNameValidationTextRange() {
        return this.nameValidationTextRange;
    }

    @Override
    public boolean nameTouches(int pos) {
        return this.textRangeTouches(this.nameTextRange, pos);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        if (ObjectTools.notEquals((Object)this.namespace, (Object)namespace)) {
            this.namespace = namespace;
            this.namespaceAdapter.setValue((Object)namespace);
        }
    }

    private void syncNamespace(String astNamespace) {
        String old = this.namespace;
        this.namespace = astNamespace;
        this.firePropertyChanged("namespace", old, astNamespace);
    }

    private String buildNamespace(Annotation astAnnotation) {
        return (String)this.namespaceAdapter.getValue(astAnnotation);
    }

    private TextRange buildNamespaceTextRange(Annotation astAnnotation) {
        return this.getAnnotationElementTextRange(NAMESPACE_ADAPTER, astAnnotation);
    }

    private TextRange buildNamespaceValidationTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(NAMESPACE_ADAPTER, astAnnotation);
    }

    @Override
    public TextRange getNamespaceTextRange() {
        return this.namespaceTextRange;
    }

    @Override
    public TextRange getNamespaceValidationTextRange() {
        return this.namespaceValidationTextRange;
    }

    @Override
    public boolean namespaceTouches(int pos) {
        return this.textRangeTouches(this.namespaceTextRange, pos);
    }

    @Override
    public ListIterable<String> getPropOrder() {
        return IterableTools.cloneLive(this.propOrder);
    }

    @Override
    public int getPropOrderSize() {
        return this.propOrder.size();
    }

    @Override
    public void addProp(String prop) {
        this.addProp(this.propOrder.size(), prop);
    }

    @Override
    public void addProp(int index, String prop) {
        this.propOrder.add(index, prop);
        this.writePropOrder();
    }

    @Override
    public void moveProp(int targetIndex, int sourceIndex) {
        ListTools.move(this.propOrder, (int)targetIndex, (int)sourceIndex);
        this.writePropOrder();
    }

    @Override
    public void removeProp(String prop) {
        this.propOrder.remove(prop);
        this.writePropOrder();
    }

    @Override
    public void removeProp(int index) {
        this.propOrder.remove(index);
        this.writePropOrder();
    }

    private void writePropOrder() {
        this.propOrderAdapter.setValue((Object)this.propOrder.toArray(new String[this.propOrder.size()]));
    }

    private void initializePropOrder(Annotation astAnnotation) {
        String[] astPropOrder = (String[])this.propOrderAdapter.getValue(astAnnotation);
        int i = 0;
        while (i < astPropOrder.length) {
            this.propOrder.add(astPropOrder[i]);
            ++i;
        }
    }

    private void syncPropOrder(Annotation astAnnotation) {
        String[] astPropOrder = (String[])this.propOrderAdapter.getValue(astAnnotation);
        this.synchronizeList(Arrays.asList(astPropOrder), this.propOrder, "propOrder");
    }

    @Override
    public TextRange getPropOrderTextRange() {
        return this.propOrderTextRange;
    }

    private TextRange buildPropOrderTextRange(Annotation astAnnotation) {
        return this.getElementTextRange((DeclarationAnnotationElementAdapter)this.propOrderDeclarationAdapter, astAnnotation);
    }

    @Override
    public boolean propOrderTouches(int pos) {
        return this.textRangeTouches(this.propOrderTextRange, pos);
    }

    private void syncPropTextRanges(Annotation astAnnotation) {
        this.propTextRanges.clear();
        int i = 0;
        while (i < this.propOrder.size()) {
            TextRange propTextRange = this.getElementTextRange(this.propOrderDeclarationAdapter, i, astAnnotation);
            this.propTextRanges.add(i, propTextRange);
            ++i;
        }
    }

    @Override
    public TextRange getPropTextRange(int index) {
        return this.propTextRanges.get(index);
    }

    @Override
    public boolean propTouches(int index, int pos) {
        return this.textRangeTouches(this.getPropTextRange(index), pos);
    }

    private static DeclarationAnnotationElementAdapter<String> buildFactoryClassAdapter() {
        return SourceXmlTypeAnnotation.buildAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "factoryClass", (ExpressionConverter<String>)SimpleTypeStringExpressionConverter.instance());
    }

    static DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    private static DeclarationAnnotationElementAdapter<String> buildFactoryMethodAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"factoryMethod");
    }

    private static DeclarationAnnotationElementAdapter<String> buildNameAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"name");
    }

    private static DeclarationAnnotationElementAdapter<String> buildNamespaceAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"namespace");
    }
}

