/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlIDREF;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.resource.java.XmlIDREFAnnotation;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.jpt.jaxb.core.xsd.XsdFeature;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericJavaXmlIDREF
extends AbstractJavaContextNode
implements XmlIDREF {
    protected final Context context;

    public GenericJavaXmlIDREF(JaxbAttributeMapping parent, Context context) {
        super(parent);
        this.context = context;
    }

    @Override
    public JaxbAttributeMapping getParent() {
        return (JaxbAttributeMapping)super.getParent();
    }

    protected JaxbPersistentAttribute getPersistentAttribute() {
        return this.getParent().getPersistentAttribute();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.context.getAnnotation().getTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        for (ValidatableReference ref : this.context.getReferences()) {
            XsdFeature xsdFeature;
            JaxbClassMapping classMapping;
            String typeName = ref.getFullyQualifiedType();
            if (!(Object.class.getName().equals(typeName) && IterableTools.size(this.context.getReferences()) == 1 || (classMapping = this.getContextRoot().getClassMapping(typeName)) != null && classMapping.getXmlIdMapping() != null)) {
                messages.add(this.buildValidationMessage(ref.getTypeValidationTextRange(), JptJaxbCoreValidationMessages.XML_ID_REF__TYPE_DOES_NOT_CONTAIN_XML_ID, typeName));
            }
            if ((xsdFeature = ref.getXsdFeature()) == null) {
                return;
            }
            if (xsdFeature == null || xsdFeature.typeIsValid(XsdUtil.getSchemaForSchema().getTypeDefinition("IDREF"), this.context.isList())) continue;
            messages.add(this.buildValidationMessage(ref.getXsdFeatureValidationTextRange(), JptJaxbCoreValidationMessages.XML_ID_REF__SCHEMA_TYPE_NOT_IDREF, xsdFeature.getName()));
        }
    }

    public static interface Context {
        public XmlIDREFAnnotation getAnnotation();

        public Iterable<ValidatableReference> getReferences();

        public boolean isList();
    }

    public static interface ValidatableReference {
        public String getFullyQualifiedType();

        public TextRange getTypeValidationTextRange();

        public XsdFeature getXsdFeature();

        public TextRange getXsdFeatureValidationTextRange();
    }
}

