/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.editor;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.editor.GlobalCommandManager;
import org.eclipse.wst.server.ui.internal.editor.ServerEditor;

public class ServerResourceCommandManager {
    protected ServerEditor editor;
    protected GlobalCommandManager commandManager;
    protected String id;

    public ServerResourceCommandManager(ServerEditor editor, String id, GlobalCommandManager commandManager) {
        this.editor = editor;
        this.commandManager = commandManager;
        this.id = id;
    }

    public boolean isReadOnly() {
        return this.commandManager.isReadOnly(this.id);
    }

    public void execute(IUndoableOperation operation) {
        if (!this.validateEdit()) {
            return;
        }
        if (this.commandManager.isReadOnly(this.id)) {
            this.warnReadOnly();
            return;
        }
        this.commandManager.executeCommand(this.id, operation);
    }

    protected void warnReadOnly() {
        String title = Messages.editorResourceWarnTitle;
        String message = Messages.editorResourceWarnMessage;
        MessageDialog.openWarning((Shell)this.editor.getEditorSite().getShell(), (String)title, (String)message);
    }

    protected boolean validateEdit() {
        if (this.commandManager.isDirty(this.id)) {
            return true;
        }
        IFile[] files = this.commandManager.getReadOnlyFiles(this.id);
        if (files.length == 0) {
            return true;
        }
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(files, (Object)this.editor.getEditorSite().getShell());
        if (status.getSeverity() == 4) {
            String message = Messages.editorValidateEditFailureMessage;
            ErrorDialog.openError((Shell)this.editor.getEditorSite().getShell(), (String)Messages.errorDialogTitle, (String)message, (IStatus)status);
            this.commandManager.setReadOnly(this.id, true);
            return false;
        }
        IServerWorkingCopy serverfile = this.commandManager.getServerResource(this.id);
        if (this.commandManager.hasChanged(this.id) && serverfile instanceof IServer) {
            this.editor.promptReloadServerFile(this.id);
        }
        return true;
    }

    public ServerEditor getServerEditor() {
        return this.editor;
    }
}

