/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELXmlDiscriminatorNode;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java.ELJavaClassMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.xpath.java.XPath;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.xpath.java.XPathFactory;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlDiscriminatorNodeAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.validation.JptJaxbEclipseLinkCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class ELJavaXmlDiscriminatorNode
extends AbstractJavaContextNode
implements ELXmlDiscriminatorNode {
    protected String value;

    public ELJavaXmlDiscriminatorNode(ELJavaClassMapping parent) {
        super((JaxbNode)parent);
        this.initValue();
    }

    protected ELJavaClassMapping getClassMapping() {
        return (ELJavaClassMapping)this.getParent();
    }

    protected JaxbPackage getJaxbPackage() {
        return this.getClassMapping().getJavaType().getJaxbPackage();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncValue();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.getAnnotation().setValue(value);
        this.setValue_(value);
    }

    protected void setValue_(String value) {
        String old = this.value;
        this.value = value;
        this.firePropertyChanged("value", old, this.value);
    }

    protected void initValue() {
        this.value = this.getAnnotation().getValue();
    }

    protected void syncValue() {
        this.setValue_(this.getAnnotation().getValue());
    }

    protected XmlDiscriminatorNodeAnnotation getAnnotation() {
        return this.getClassMapping().getXmlDiscriminatorNodeAnnotation();
    }

    public Iterable<String> getCompletionProposals(int pos) {
        if (this.getAnnotation().valueTouches(pos) && this.value != null) {
            XsdTypeDefinition xsdType = this.getClassMapping().getXsdTypeDefinition();
            XPath xpath = XPathFactory.instance().getXpath(this.value);
            return xpath.getCompletionProposals(new XPathContext(), xsdType, pos);
        }
        return EmptyIterable.instance();
    }

    public TextRange getValidationTextRange() {
        return this.getAnnotation().getTextRange();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (StringTools.isBlank((String)this.value)) {
            messages.add(this.buildValidationMessage((JaxbNode)this, this.getValueTextRange(), JptJaxbEclipseLinkCoreValidationMessages.XML_DISCRIMINATOR_NODE__NOT_SPECIFIED));
            return;
        }
        if (this.value.startsWith(XPath.DELIM)) {
            messages.add(this.buildValidationMessage((JaxbNode)this, this.getValueTextRange(), JptJaxbEclipseLinkCoreValidationMessages.XPATH__ROOT_NOT_SUPPORTED));
            return;
        }
        XsdTypeDefinition xsdType = this.getClassMapping().getXsdTypeDefinition();
        XPath xpath = XPathFactory.instance().getXpath(this.value);
        xpath.validate(new XPathContext(), xsdType, messages);
    }

    protected TextRange getValueTextRange() {
        return this.getAnnotation().getValueTextRange();
    }

    protected class XPathContext
    extends XPath.AbstractContext {
        protected XPathContext() {
        }

        @Override
        public JaxbNode getContextObject() {
            return ELJavaXmlDiscriminatorNode.this;
        }

        @Override
        public JaxbPackage getJaxbPackage() {
            return ELJavaXmlDiscriminatorNode.this.getJaxbPackage();
        }

        @Override
        public TextRange getTextRange() {
            return ELJavaXmlDiscriminatorNode.this.getValueTextRange();
        }
    }
}

