/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.resource.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EnumType implements Enumerator
{
    ORDINAL(0, "ORDINAL", "ORDINAL"),
    STRING(1, "STRING", "STRING");

    public static final int ORDINAL_VALUE = 0;
    public static final int STRING_VALUE = 1;
    private static final EnumType[] VALUES_ARRAY;
    public static final List<EnumType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EnumType[]{ORDINAL, STRING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EnumType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EnumType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EnumType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EnumType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EnumType get(int value) {
        switch (value) {
            case 0: {
                return ORDINAL;
            }
            case 1: {
                return STRING;
            }
        }
        return null;
    }

    private EnumType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

