/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards;

import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.swt.widgets.ControlTools;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.jpa.core.JpaWorkspace;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetInstallDataModelProperties;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.ConnectionProfileFactory;
import org.eclipse.jpt.jpa.db.ui.internal.DTPUiTools;
import org.eclipse.jpt.jpa.ui.JpaWorkbench;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.wizards.JpaFacetActionPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class JpaFacetInstallPage
extends JpaFacetActionPage
implements JpaFacetInstallDataModelProperties {
    public JpaFacetInstallPage() {
        super("jpt.jpa.facet.install.page");
    }

    @Override
    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = super.createTopLevelComposite(parent);
        WorkbenchTools.setHelp((Control)composite, (String)JpaHelpContextIds.NEW_JPA_PROJECT_JPA_FACET);
        return composite;
    }

    @Override
    protected void addSubComposites(Composite composite) {
        new JpaFacetActionPage.PlatformGroup(composite);
        new JpaFacetActionPage.ClasspathConfigGroup(composite);
        new ConnectionGroup(composite);
        new JpaFacetActionPage.PersistentClassManagementGroup(composite);
    }

    @Override
    protected String[] getValidationPropertyNames() {
        Object[] validationPropertyNames = super.getValidationPropertyNames();
        return (String[])ArrayTools.addAll((Object[])validationPropertyNames, (Object[])new String[]{"JpaFacetInstallDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH", "JpaFacetInstallDataModelProperties.DB_DRIVER_NAME"});
    }

    protected final class ConnectionGroup {
        private final Combo connectionCombo;
        private final Link connectionLink;
        private final Link connectLink;
        private final Button addDriverLibraryButton;
        private final Label driverLibraryLabel;
        private final Combo driverLibraryCombo;
        private final Button overrideDefaultCatalogButton;
        private final Label defaultCatalogLabel;
        private final Combo defaultCatalogCombo;
        private final Button overrideDefaultSchemaButton;
        private final Label defaultSchemaLabel;
        private final Combo defaultSchemaCombo;

        public ConnectionGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_CONNECTION_LABEL);
            group.setLayout((Layout)new GridLayout(3, false));
            group.setLayoutData((Object)new GridData(768));
            WorkbenchTools.setHelp((Control)group, (String)JpaHelpContextIds.NEW_JPA_PROJECT_CONTENT_PAGE_DATABASE);
            this.connectionCombo = JpaFacetInstallPage.this.createCombo((Composite)group, 3, true);
            JpaFacetInstallPage.this.synchHelper.synchCombo(this.connectionCombo, "JpaFacetDataModelProperties.CONNECTION", null);
            this.connectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionGroup.this.updateConnectionStatus();
                }
            });
            this.connectionLink = new Link((Composite)group, 0);
            GridData data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.connectionLink.setLayoutData((Object)data);
            this.connectionLink.setText(JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_CONNECTION_LINK);
            this.connectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionGroup.this.openNewConnectionWizard();
                }
            });
            this.connectLink = new Link((Composite)group, 0);
            data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.connectLink.setLayoutData((Object)data);
            this.connectLink.setText(JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_CONNECT_LINK);
            this.connectLink.setEnabled(false);
            this.connectLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionGroup.this.openConnectionProfile();
                }
            });
            this.addDriverLibraryButton = JpaFacetInstallPage.this.createButton((Composite)group, 3, JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_ADD_DRIVER_LIBRARY_LABEL, 32);
            this.addDriverLibraryButton.setSelection(false);
            JpaFacetInstallPage.this.synchHelper.synchCheckbox(this.addDriverLibraryButton, "JpaFacetInstallDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH", null);
            this.driverLibraryLabel = new Label((Composite)group, 16384);
            this.driverLibraryLabel.setText(JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_DRIVER_LIBRARY_LABEL);
            GridData gd = new GridData();
            gd.horizontalSpan = 1;
            this.driverLibraryLabel.setLayoutData((Object)gd);
            this.driverLibraryCombo = JpaFacetInstallPage.this.createCombo((Composite)group, 1, true);
            JpaFacetInstallPage.this.synchHelper.synchCombo(this.driverLibraryCombo, "JpaFacetInstallDataModelProperties.DB_DRIVER_NAME", new Control[]{this.driverLibraryLabel});
            this.overrideDefaultCatalogButton = JpaFacetInstallPage.this.createButton((Composite)group, 3, JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_OVERRIDE_DEFAULT_CATALOG_LABEL, 32);
            this.overrideDefaultCatalogButton.setSelection(false);
            JpaFacetInstallPage.this.synchHelper.synchCheckbox(this.overrideDefaultCatalogButton, "JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG", null);
            this.defaultCatalogLabel = new Label((Composite)group, 16384);
            this.defaultCatalogLabel.setText(JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_DEFAULT_CATALOG_LABEL);
            gd = new GridData();
            gd.horizontalSpan = 1;
            this.defaultCatalogLabel.setLayoutData((Object)gd);
            this.defaultCatalogCombo = JpaFacetInstallPage.this.createCombo((Composite)group, 1, true);
            JpaFacetInstallPage.this.synchHelper.synchCombo(this.defaultCatalogCombo, "JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG", new Control[]{this.defaultCatalogLabel});
            this.overrideDefaultSchemaButton = JpaFacetInstallPage.this.createButton((Composite)group, 3, JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_OVERRIDE_DEFAULT_SCHEMA_LABEL, 32);
            this.overrideDefaultSchemaButton.setSelection(false);
            JpaFacetInstallPage.this.synchHelper.synchCheckbox(this.overrideDefaultSchemaButton, "JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA", null);
            this.defaultSchemaLabel = new Label((Composite)group, 16384);
            this.defaultSchemaLabel.setText(JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_DEFAULT_SCHEMA_LABEL);
            gd = new GridData();
            gd.horizontalSpan = 1;
            this.defaultSchemaLabel.setLayoutData((Object)gd);
            this.defaultSchemaCombo = JpaFacetInstallPage.this.createCombo((Composite)group, 1, true);
            JpaFacetInstallPage.this.synchHelper.synchCombo(this.defaultSchemaCombo, "JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", new Control[]{this.defaultSchemaLabel});
        }

        private void openNewConnectionWizard() {
            String connectionName = DTPUiTools.createNewConnectionProfile();
            if (connectionName != null) {
                JpaFacetInstallPage.this.model.setProperty("JpaFacetDataModelProperties.CONNECTION", (Object)connectionName);
                this.updateConnectionStatus();
            }
        }

        private void openConnectionProfile() {
            ConnectionProfile cp = this.getConnectionProfile();
            if (cp != null) {
                cp.connect();
                JpaFacetInstallPage.this.model.setBooleanProperty("JpaFacetDataModelProperties.CONNECTION_ACTIVE", cp.isActive());
                this.updateConnectionStatus();
            }
        }

        private void updateConnectionStatus() {
            ConnectionProfile cp = this.getConnectionProfile();
            this.updateConnectLink(cp);
            this.addDriverLibraryButton.setEnabled(cp != null);
        }

        private ConnectionProfile getConnectionProfile() {
            ConnectionProfileFactory factory = this.getConnectionProfileFactory();
            return factory == null ? null : factory.buildConnectionProfile(JpaFacetInstallPage.this.model.getStringProperty("JpaFacetDataModelProperties.CONNECTION"));
        }

        private ConnectionProfileFactory getConnectionProfileFactory() {
            JpaWorkspace jpaWorkspace = this.getJpaWorkspace();
            return jpaWorkspace == null ? null : jpaWorkspace.getConnectionProfileFactory();
        }

        private JpaWorkspace getJpaWorkspace() {
            JpaWorkbench jpaWorkbench = this.getJpaWorkbench();
            return jpaWorkbench == null ? null : jpaWorkbench.getJpaWorkspace();
        }

        private JpaWorkbench getJpaWorkbench() {
            return (JpaWorkbench)WorkbenchTools.getAdapter(JpaWorkbench.class);
        }

        private void updateConnectLink(ConnectionProfile cp) {
            this.connectLink.setEnabled(cp != null && cp.isDisconnected());
            if (cp != null && cp.isConnected()) {
                this.updateConnectLinkText(JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_CONNECTED_TEXT);
            } else {
                this.updateConnectLinkText(JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_CONNECT_LINK);
            }
        }

        private void updateConnectLinkText(String text) {
            this.connectLink.setText(text);
            ControlTools.reflow((Control)this.connectLink);
        }
    }
}

