/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.reference;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.internal.predicate.int_.IntPredicateTools;
import org.eclipse.jpt.common.utility.predicate.IntPredicate;
import org.eclipse.jpt.common.utility.reference.IntReference;
import org.eclipse.jpt.common.utility.reference.ModifiableIntReference;

public class SynchronizedInt
implements ModifiableIntReference,
Cloneable,
Serializable {
    private int value;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedInt(int value, Object mutex) {
        this.value = value;
        this.mutex = mutex;
    }

    public SynchronizedInt(int value) {
        this.value = value;
        this.mutex = this;
    }

    public SynchronizedInt(Object mutex) {
        this(0, mutex);
    }

    public SynchronizedInt() {
        this(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getValue() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value == i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notEqual(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value != i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isZero() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNotZero() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGreaterThan(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value > i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGreaterThanOrEqual(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value >= i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLessThan(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value < i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLessThanOrEqual(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value <= i;
        }
    }

    @Override
    public boolean isPositive() {
        return this.isGreaterThan(0);
    }

    @Override
    public boolean isNotPositive() {
        return this.isLessThanOrEqual(0);
    }

    @Override
    public boolean isNegative() {
        return this.isLessThan(0);
    }

    @Override
    public boolean isNotNegative() {
        return this.isGreaterThanOrEqual(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMemberOf(IntPredicate predicate) {
        Object object = this.mutex;
        synchronized (object) {
            return predicate.evaluate(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNotMemberOf(IntPredicate predicate) {
        Object object = this.mutex;
        synchronized (object) {
            return !predicate.evaluate(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setValue(int value) {
        Object object = this.mutex;
        synchronized (object) {
            return this.setValue_(value);
        }
    }

    private int setValue_(int v) {
        int old = this.value;
        return old == v ? old : this.setValue_(v, old);
    }

    private int setChangedValue_(int v) {
        return this.setValue_(v, this.value);
    }

    private int setValue_(int v, int old) {
        this.value = v;
        this.mutex.notifyAll();
        return old;
    }

    @Override
    public int setZero() {
        return this.setValue(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int increment() {
        Object object = this.mutex;
        synchronized (object) {
            ++this.value;
            this.mutex.notifyAll();
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int incrementExact() {
        Object object = this.mutex;
        synchronized (object) {
            this.value = Math.incrementExact(this.value);
            this.mutex.notifyAll();
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int decrement() {
        Object object = this.mutex;
        synchronized (object) {
            --this.value;
            this.mutex.notifyAll();
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int decrementExact() {
        Object object = this.mutex;
        synchronized (object) {
            this.value = Math.decrementExact(this.value);
            this.mutex.notifyAll();
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int halve() {
        Object object = this.mutex;
        synchronized (object) {
            return this.halve_();
        }
    }

    private int halve_() {
        int old = this.value;
        this.value = BitTools.half(old);
        if (this.value != old) {
            this.mutex.notifyAll();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int twice() {
        Object object = this.mutex;
        synchronized (object) {
            return this.twice_();
        }
    }

    private int twice_() {
        int old = this.value;
        this.value = BitTools.twice(old);
        if (this.value != old) {
            this.mutex.notifyAll();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int twiceExact() {
        Object object = this.mutex;
        synchronized (object) {
            return this.twiceExact_();
        }
    }

    private int twiceExact_() {
        int old = this.value;
        this.value = Math.multiplyExact(old, 2);
        if (this.value != old) {
            this.mutex.notifyAll();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int abs() {
        Object object = this.mutex;
        synchronized (object) {
            return this.abs_();
        }
    }

    private int abs_() {
        int old = this.value;
        this.value = Math.abs(old);
        if (this.value != old) {
            this.mutex.notifyAll();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int negate() {
        Object object = this.mutex;
        synchronized (object) {
            this.value = -this.value;
            this.mutex.notifyAll();
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int negateExact() {
        Object object = this.mutex;
        synchronized (object) {
            this.value = Math.negateExact(this.value);
            this.mutex.notifyAll();
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.add_(i);
        }
    }

    private int add_(int i) {
        int old = this.value;
        this.value += i;
        if (this.value != old) {
            this.mutex.notifyAll();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addExact(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.addExact_(i);
        }
    }

    private int addExact_(int i) {
        int old = this.value;
        this.value = Math.addExact(this.value, i);
        if (this.value != old) {
            this.mutex.notifyAll();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int subtract(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.subtract_(i);
        }
    }

    private int subtract_(int i) {
        int old = this.value;
        this.value -= i;
        if (this.value != old) {
            this.mutex.notifyAll();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int subtractExact(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.subtractExact_(i);
        }
    }

    private int subtractExact_(int i) {
        int old = this.value;
        this.value = Math.subtractExact(this.value, i);
        if (this.value != old) {
            this.mutex.notifyAll();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int multiply(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.multiply_(i);
        }
    }

    private int multiply_(int i) {
        int old = this.value;
        this.value *= i;
        if (this.value != old) {
            this.mutex.notifyAll();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int multiplyExact(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.multiplyExact_(i);
        }
    }

    private int multiplyExact_(int i) {
        int old = this.value;
        this.value = Math.multiplyExact(this.value, i);
        if (this.value != old) {
            this.mutex.notifyAll();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int divide(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.divide_(i);
        }
    }

    private int divide_(int i) {
        int old = this.value;
        this.value /= i;
        if (this.value != old) {
            this.mutex.notifyAll();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int floorDivide(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.floorDivide_(i);
        }
    }

    private int floorDivide_(int i) {
        int old = this.value;
        this.value = Math.floorDiv(this.value, i);
        if (this.value != old) {
            this.mutex.notifyAll();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remainder(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.remainder_(i);
        }
    }

    private int remainder_(int i) {
        int old = this.value;
        this.value %= i;
        if (this.value != old) {
            this.mutex.notifyAll();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int floorRemainder(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.floorRemainder_(i);
        }
    }

    private int floorRemainder_(int i) {
        int old = this.value;
        this.value = Math.floorMod(this.value, i);
        if (this.value != old) {
            this.mutex.notifyAll();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int min(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.min_(i);
        }
    }

    private int min_(int i) {
        int old = this.value;
        this.value = Math.min(this.value, i);
        if (this.value != old) {
            this.mutex.notifyAll();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int max(int i) {
        Object object = this.mutex;
        synchronized (object) {
            return this.max_(i);
        }
    }

    private int max_(int i) {
        int old = this.value;
        this.value = Math.max(this.value, i);
        if (this.value != old) {
            this.mutex.notifyAll();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commit(int newValue, int expectedValue) {
        Object object = this.mutex;
        synchronized (object) {
            return this.commit_(newValue, expectedValue);
        }
    }

    private boolean commit_(int newValue, int expectedValue) {
        if (this.value == expectedValue) {
            this.setValue_(newValue);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int swap(ModifiableIntReference other) {
        if (other == this) {
            return this.getValue();
        }
        if (other instanceof SynchronizedInt) {
            return this.swap_((SynchronizedInt)other);
        }
        int thisValue = 0;
        int otherValue = other.getValue();
        Object object = this.mutex;
        synchronized (object) {
            thisValue = this.value;
            if (thisValue != otherValue) {
                this.setChangedValue_(otherValue);
            }
        }
        other.setValue(thisValue);
        return otherValue;
    }

    public int swap(SynchronizedInt other) {
        return other == this ? this.getValue() : this.swap_(other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int swap_(SynchronizedInt other) {
        boolean thisFirst = System.identityHashCode(this) < System.identityHashCode(other);
        SynchronizedInt first = thisFirst ? this : other;
        SynchronizedInt second = thisFirst ? other : this;
        Object object = first.mutex;
        synchronized (object) {
            Object object2 = second.mutex;
            synchronized (object2) {
                int thisValue = this.value;
                int otherValue = other.value;
                if (thisValue == otherValue) {
                    return thisValue;
                }
                other.setChangedValue_(thisValue);
                this.setChangedValue_(otherValue);
                return otherValue;
            }
        }
    }

    public Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntil(IntPredicate predicate) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntil_(predicate);
        }
    }

    private void waitUntil_(IntPredicate predicate) throws InterruptedException {
        while (!predicate.evaluate(this.value)) {
            this.mutex.wait();
        }
    }

    public void waitUntilNot(IntPredicate predicate) throws InterruptedException {
        this.waitUntil(IntPredicateTools.not(predicate));
    }

    public void waitUntilEqual(int i) throws InterruptedException {
        this.waitUntil(IntPredicateTools.isEqual(i));
    }

    public void waitUntilNotEqual(int i) throws InterruptedException {
        this.waitUntil(IntPredicateTools.notEqual(i));
    }

    public void waitUntilZero() throws InterruptedException {
        this.waitUntilEqual(0);
    }

    public void waitUntilNotZero() throws InterruptedException {
        this.waitUntilNotEqual(0);
    }

    public void waitUntilGreaterThan(int i) throws InterruptedException {
        this.waitUntil(IntPredicateTools.isGreaterThan(i));
    }

    public void waitUntilGreaterThanOrEqual(int i) throws InterruptedException {
        this.waitUntil(IntPredicateTools.isGreaterThanOrEqual(i));
    }

    public void waitUntilLessThan(int i) throws InterruptedException {
        this.waitUntil(IntPredicateTools.isLessThan(i));
    }

    public void waitUntilLessThanOrEqual(int i) throws InterruptedException {
        this.waitUntil(IntPredicateTools.isLessThanOrEqual(i));
    }

    public void waitUntilPositive() throws InterruptedException {
        this.waitUntilGreaterThan(0);
    }

    public void waitUntilNotPositive() throws InterruptedException {
        this.waitUntilLessThanOrEqual(0);
    }

    public void waitUntilNegative() throws InterruptedException {
        this.waitUntilLessThan(0);
    }

    public void waitUntilNotNegative() throws InterruptedException {
        this.waitUntilGreaterThanOrEqual(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitToSetValue(int i) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntil_(IntPredicateTools.notEqual(i));
            return this.setChangedValue_(i);
        }
    }

    public int waitToSetZero() throws InterruptedException {
        return this.waitToSetValue(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitToCommit(int newValue, int expectedValue) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntil_(IntPredicateTools.isEqual(expectedValue));
            return this.setValue_(newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntil(IntPredicate predicate, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntil_(predicate, timeout);
        }
    }

    private boolean waitUntil_(IntPredicate predicate, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntil_(predicate);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (!predicate.evaluate(this.value) && remaining > 0L) {
            this.mutex.wait(remaining);
            remaining = stop - System.currentTimeMillis();
        }
        return predicate.evaluate(this.value);
    }

    public boolean waitUntilNot(IntPredicate predicate, long timeout) throws InterruptedException {
        return this.waitUntil(IntPredicateTools.not(predicate), timeout);
    }

    public boolean waitUntilEqual(int i, long timeout) throws InterruptedException {
        return this.waitUntil(IntPredicateTools.isEqual(i), timeout);
    }

    public boolean waitUntilNotEqual(int i, long timeout) throws InterruptedException {
        return this.waitUntil(IntPredicateTools.notEqual(i), timeout);
    }

    public boolean waitUntilZero(long timeout) throws InterruptedException {
        return this.waitUntilEqual(0, timeout);
    }

    public boolean waitUntilNotZero(long timeout) throws InterruptedException {
        return this.waitUntilNotEqual(0, timeout);
    }

    public boolean waitUntilGreaterThan(int i, long timeout) throws InterruptedException {
        return this.waitUntil(IntPredicateTools.isGreaterThan(i), timeout);
    }

    public boolean waitUntilGreaterThanOrEqual(int i, long timeout) throws InterruptedException {
        return this.waitUntil(IntPredicateTools.isGreaterThanOrEqual(i), timeout);
    }

    public boolean waitUntilLessThan(int i, long timeout) throws InterruptedException {
        return this.waitUntil(IntPredicateTools.isLessThan(i), timeout);
    }

    public boolean waitUntilLessThanOrEqual(int i, long timeout) throws InterruptedException {
        return this.waitUntil(IntPredicateTools.isLessThanOrEqual(i), timeout);
    }

    public boolean waitUntilPositive(long timeout) throws InterruptedException {
        return this.waitUntilGreaterThan(0, timeout);
    }

    public boolean waitUntilNotPositive(long timeout) throws InterruptedException {
        return this.waitUntilLessThanOrEqual(0, timeout);
    }

    public boolean waitUntilNegative(long timeout) throws InterruptedException {
        return this.waitUntilLessThan(0, timeout);
    }

    public boolean waitUntilNotNegative(long timeout) throws InterruptedException {
        return this.waitUntilGreaterThanOrEqual(0, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetValue(int i, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntil_(IntPredicateTools.notEqual(i), timeout);
            if (success) {
                this.setChangedValue_(i);
            }
            return success;
        }
    }

    public boolean waitToSetZero(long timeout) throws InterruptedException {
        return this.waitToSetValue(0, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToCommit(int newValue, int expectedValue, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntil_(IntPredicateTools.isEqual(expectedValue), timeout);
            if (success) {
                this.setValue_(newValue);
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    @Override
    public int compareTo(IntReference other) {
        int otherValue;
        int thisValue = this.getValue();
        return thisValue < (otherValue = other.getValue()) ? -1 : (thisValue == otherValue ? 0 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizedInt clone() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                return (SynchronizedInt)super.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.getValue()) + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            s.defaultWriteObject();
        }
    }
}

