/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import java.util.Vector;

public class SQLStringHelper {
    public static final String lineSeparator = System.getProperties().getProperty("line.separator");
    private static final String ALPHANUMERIC_UNDERSCORE = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";

    public static String trimBlanks(Object input) {
        String result = input.toString();
        result = SQLStringHelper.change(result, System.getProperties().getProperty("line.separator"), " ");
        Vector literalVector = new Vector();
        String tempPattern = "#TAG#";
        result = SQLStringHelper.stringReplace(result, "'", "'", tempPattern, literalVector);
        while (result.indexOf("  ") != -1) {
            result = SQLStringHelper.change(result, "  ", " ");
        }
        result = SQLStringHelper.stringReplace(result, tempPattern, literalVector);
        return result;
    }

    public static String stringReplace(String string, String startDelimiter, String endDelimiter, String tag, Vector litVector) {
        int startSearchIndex = 0;
        while (string.indexOf(startDelimiter, startSearchIndex) != -1) {
            int startLitIndex = string.indexOf(startDelimiter, startSearchIndex);
            int endLitIndex = string.indexOf(endDelimiter, startLitIndex + 1);
            if (endLitIndex == -1) {
                endLitIndex = startLitIndex;
            }
            char[] litValue = new char[endLitIndex + 1 - startLitIndex];
            string.getChars(startLitIndex, endLitIndex + 1, litValue, 0);
            litVector.addElement(litValue);
            StringBuffer sb = new StringBuffer(string);
            sb = sb.replace(startLitIndex, endLitIndex + 1, tag);
            string = new String(sb);
            startSearchIndex = startLitIndex + tag.length();
        }
        return string;
    }

    public static String stringReplace(String string, String pattern, Vector newVector) {
        int startSearchIndex = 0;
        boolean exit = false;
        int length = pattern.length();
        String startDelimiter = pattern.substring(0, 1);
        String endDelimiter = pattern.substring(length - 1, length);
        while (string.indexOf(startDelimiter, startSearchIndex) != -1 && !exit) {
            if (newVector.size() >= 1) {
                int startLitIndex = string.indexOf(startDelimiter, startSearchIndex);
                int endLitIndex = string.indexOf(endDelimiter, startLitIndex + 1);
                char[] litValue = new char[endLitIndex + 1 - startLitIndex];
                string.getChars(startLitIndex, endLitIndex + 1, litValue, 0);
                if (pattern.equals(new String(litValue))) {
                    String tag = new String((char[])newVector.firstElement());
                    newVector.remove(0);
                    StringBuffer sb = new StringBuffer(string);
                    sb = sb.replace(startLitIndex, endLitIndex + 1, tag);
                    string = new String(sb);
                    startSearchIndex = startLitIndex + tag.length();
                    continue;
                }
                ++startSearchIndex;
                continue;
            }
            exit = true;
        }
        return string;
    }

    public static boolean isAlphanumericOrUnderscore(String srcString) {
        return SQLStringHelper.lastIndexOfAnyBut(srcString, ALPHANUMERIC_UNDERSCORE) == -1;
    }

    public static int lastIndexOfAnyBut(String srcString, String validString) {
        int result = -1;
        int srcLen = srcString.length();
        int i = srcLen - 1;
        while (i >= 0) {
            if (validString.indexOf(srcString.charAt(i)) == -1) {
                result = i;
                break;
            }
            --i;
        }
        return result;
    }

    private static String change(String in, String oldPat, String newPat) {
        if (oldPat.length() == 0) {
            return in;
        }
        if (oldPat.length() == 1 && newPat.length() == 1) {
            return in.replace(oldPat.charAt(0), newPat.charAt(0));
        }
        int lastIndex = 0;
        int newIndex = 0;
        StringBuffer newString = new StringBuffer();
        while ((newIndex = in.indexOf(oldPat, lastIndex)) != -1) {
            newString.append(String.valueOf(in.substring(lastIndex, newIndex)) + newPat);
            lastIndex = newIndex + oldPat.length();
        }
        newString.append(in.substring(lastIndex));
        return newString.toString();
    }
}

