/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.console;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.eclipse.buildship.core.internal.console.ProcessDescription;
import org.eclipse.buildship.ui.internal.PluginImage;
import org.eclipse.buildship.ui.internal.PluginImages;
import org.eclipse.buildship.ui.internal.console.ConsoleMessages;
import org.eclipse.buildship.ui.internal.console.GradleConsole;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;

public final class RemoveTerminatedGradleConsoleAction
extends Action {
    private final GradleConsole gradleConsole;

    public RemoveTerminatedGradleConsoleAction(GradleConsole gradleConsole) {
        this.gradleConsole = (GradleConsole)((Object)Preconditions.checkNotNull((Object)((Object)gradleConsole)));
        this.setToolTipText(ConsoleMessages.Action_RemoveTerminatedConsole_Tooltip);
        this.setImageDescriptor(PluginImages.REMOVE_CONSOLE.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
        this.setDisabledImageDescriptor(PluginImages.REMOVE_CONSOLE.withState(PluginImage.ImageState.DISABLED).getImageDescriptor());
        this.registerJobChangeListener();
    }

    private void registerJobChangeListener() {
        Optional<ProcessDescription> processDescription = this.gradleConsole.getProcessDescription();
        if (processDescription.isPresent()) {
            Job job = ((ProcessDescription)processDescription.get()).getJob();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    RemoveTerminatedGradleConsoleAction.this.update();
                }
            });
            this.update();
        } else {
            this.setEnabled(false);
        }
    }

    private void update() {
        this.setEnabled(this.gradleConsole.isCloseable() && this.gradleConsole.isTerminated());
    }

    public void run() {
        ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this.gradleConsole});
    }

    public void dispose() {
    }
}

