/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.ui.texteditor.IUpdate;

public class MatchFilterAction
extends Action
implements IUpdate {
    private final MatchFilter fFilter;
    private final AbstractTextSearchViewPage fPage;

    public MatchFilterAction(AbstractTextSearchViewPage page, MatchFilter filter) {
        super(filter.getActionLabel(), 2);
        this.fPage = page;
        this.fFilter = filter;
        this.setId("MatchFilterAction." + filter.getID());
        this.setChecked(this.isActiveMatchFilter());
    }

    public void run() {
        AbstractTextSearchResult input = this.fPage.getInput();
        if (input == null) {
            return;
        }
        ArrayList<MatchFilter> newFilters = new ArrayList<MatchFilter>();
        MatchFilter[] activeMatchFilters = input.getActiveMatchFilters();
        if (activeMatchFilters == null) {
            return;
        }
        MatchFilter[] matchFilterArray = activeMatchFilters;
        int n = activeMatchFilters.length;
        int n2 = 0;
        while (n2 < n) {
            MatchFilter activeMatchFilter = matchFilterArray[n2];
            if (!activeMatchFilter.equals(this.fFilter)) {
                newFilters.add(activeMatchFilter);
            }
            ++n2;
        }
        boolean newState = this.isChecked();
        if (newState) {
            newFilters.add(this.fFilter);
        }
        input.setActiveMatchFilters(newFilters.toArray(new MatchFilter[newFilters.size()]));
    }

    public MatchFilter getFilter() {
        return this.fFilter;
    }

    private boolean isActiveMatchFilter() {
        AbstractTextSearchResult input = this.fPage.getInput();
        if (input != null) {
            MatchFilter[] activeMatchFilters;
            MatchFilter[] matchFilterArray = activeMatchFilters = input.getActiveMatchFilters();
            int n = activeMatchFilters.length;
            int n2 = 0;
            while (n2 < n) {
                MatchFilter activeMatchFilter = matchFilterArray[n2];
                if (this.fFilter.equals(activeMatchFilter)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void update() {
        this.setChecked(this.isActiveMatchFilter());
    }
}

