/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.TomcatPlugin;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.TomcatVersionHelper;
import org.eclipse.wst.server.core.IModule;

public class Tomcat41Handler
implements ITomcatVersionHandler {
    @Override
    public IStatus verifyInstallPath(IPath installPath) {
        IStatus result = TomcatVersionHelper.checkCatalinaVersion(installPath, "org.eclipse.jst.server.tomcat.41");
        if (result.getSeverity() == 8) {
            result = TomcatPlugin.verifyInstallPathWithFolderCheck(installPath, "org.eclipse.jst.server.tomcat.41");
        }
        return result;
    }

    @Override
    public String getRuntimeClass() {
        return "org.apache.catalina.startup.Bootstrap";
    }

    @Override
    public List getRuntimeClasspath(IPath installPath, IPath configPath) {
        ArrayList<IRuntimeClasspathEntry> cp = new ArrayList<IRuntimeClasspathEntry>();
        IPath binPath = installPath.append("bin");
        if (binPath.toFile().exists()) {
            IPath path = binPath.append("bootstrap.jar");
            cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
        }
        return cp;
    }

    @Override
    public String[] getRuntimeProgramArguments(IPath configPath, boolean debug, boolean starting) {
        ArrayList<String> list = new ArrayList<String>();
        if (debug) {
            list.add("-debug");
        }
        if (starting) {
            list.add("start");
        } else {
            list.add("stop");
        }
        String[] temp = new String[list.size()];
        list.toArray(temp);
        return temp;
    }

    @Override
    public String[] getExcludedRuntimeProgramArguments(boolean debug, boolean starting) {
        if (!debug) {
            return new String[]{"-debug"};
        }
        return null;
    }

    @Override
    public String[] getRuntimeVMArguments(IPath installPath, IPath configPath, IPath deployPath, boolean isTestEnv) {
        return TomcatVersionHelper.getCatalinaVMArguments(installPath, configPath, deployPath, isTestEnv);
    }

    @Override
    public String getRuntimePolicyFile(IPath configPath) {
        return configPath.append("conf").append("catalina.policy").toOSString();
    }

    @Override
    public IStatus canAddModule(IModule module) {
        String version = module.getModuleType().getVersion();
        if ("2.2".equals(version) || "2.3".equals(version)) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorSpec41, null);
    }

    @Override
    public IPath getRuntimeBaseDirectory(TomcatServer server) {
        return TomcatVersionHelper.getStandardBaseDirectory(server);
    }

    @Override
    public IStatus prepareRuntimeDirectory(IPath baseDir) {
        return TomcatVersionHelper.createCatalinaInstanceDirectory(baseDir);
    }

    @Override
    public IStatus prepareDeployDirectory(IPath deployPath) {
        return TomcatVersionHelper.createDeploymentDirectory(deployPath, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\">\n<web-app>\n</web-app>");
    }

    @Override
    public IStatus prepareForServingDirectly(IPath baseDir, TomcatServer server, String tomcatVersion) {
        if (server.isServeModulesWithoutPublish()) {
            return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorNoPublishNotSupported, null);
        }
        return Status.OK_STATUS;
    }

    @Override
    public String getSharedLoader(IPath baseDir) {
        return null;
    }

    @Override
    public boolean supportsServeModulesWithoutPublish() {
        return false;
    }

    @Override
    public boolean supportsDebugArgument() {
        return true;
    }

    @Override
    public boolean supportsSeparateContextFiles() {
        return false;
    }

    @Override
    public String getEndorsedDirectories(IPath installPath) {
        return installPath.append("common").append("endorsed").toOSString();
    }
}

