/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.internal.debug.core.refactoring.BreakpointChange;

public abstract class ExceptionBreakpointChange
extends BreakpointChange {
    private final String[] fExclusionFilters;
    private final String[] fInclusionFilters;
    boolean fCaught;
    boolean fUncaught;
    boolean fChecked;

    public ExceptionBreakpointChange(IJavaExceptionBreakpoint breakpoint) throws CoreException {
        super((IJavaBreakpoint)breakpoint);
        this.fExclusionFilters = breakpoint.getExclusionFilters();
        this.fInclusionFilters = breakpoint.getInclusionFilters();
        this.fCaught = breakpoint.isCaught();
        this.fUncaught = breakpoint.isUncaught();
        this.fChecked = breakpoint.isChecked();
    }

    protected boolean isChecked() {
        return this.fChecked;
    }

    protected boolean isCaught() {
        return this.fCaught;
    }

    protected boolean isUncaught() {
        return this.fUncaught;
    }

    protected void apply(IJavaExceptionBreakpoint breakpoint) throws CoreException {
        super.apply((IJavaBreakpoint)breakpoint);
        breakpoint.setExclusionFilters(this.fExclusionFilters);
        breakpoint.setInclusionFilters(this.fInclusionFilters);
        breakpoint.setCaught(this.fCaught);
        breakpoint.setUncaught(this.fUncaught);
    }
}

