/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.xalan.debugger;

import java.util.TooManyListenersException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xalan.trace.TraceListener;
import org.apache.xalan.trace.TraceManager;
import org.apache.xalan.transformer.TransformerImpl;
import org.eclipse.wst.xsl.jaxp.debug.debugger.AbstractDebugger;
import org.eclipse.wst.xsl.jaxp.debug.debugger.BreakPoint;
import org.eclipse.wst.xsl.jaxp.debug.debugger.Variable;
import org.eclipse.wst.xsl.xalan.debugger.XalanTraceListener;
import org.xml.sax.SAXException;

public class XalanDebugger
extends AbstractDebugger {
    private static final Log log = LogFactory.getLog(XalanDebugger.class);
    private XalanTraceListener currentTraceListener;
    private TransformerImpl lastTransformerInChain;

    public void setTransformerFactory(TransformerFactory factory) {
        TransformerFactoryImpl tfi = (TransformerFactoryImpl)factory;
        tfi.setAttribute("http://xml.apache.org/xalan/properties/source-location", (Object)Boolean.TRUE);
        tfi.setAttribute("http://xml.apache.org/xalan/features/optimize", (Object)Boolean.FALSE);
    }

    public synchronized void debuggerSuspended(BreakPoint breakpoint) {
        try {
            this.lastTransformerInChain.getSerializationHandler().flushPending();
        }
        catch (SAXException e) {
            log.error((Object)"Error flushing serializer", (Throwable)e);
        }
        super.debuggerSuspended(breakpoint);
    }

    public void addTransformer(Transformer transformer) {
        TransformerImpl transformerImpl;
        this.lastTransformerInChain = transformerImpl = (TransformerImpl)transformer;
        TraceManager trMgr = transformerImpl.getTraceManager();
        try {
            XalanTraceListener traceListener = new XalanTraceListener(this);
            trMgr.addTraceListener((TraceListener)traceListener);
        }
        catch (TooManyListenersException tooManyListenersException) {}
    }

    public Variable getVariable(int id) {
        return this.currentTraceListener.getVariable(id);
    }

    void setCurrentTraceListener(XalanTraceListener currentTraceListener) {
        log.debug((Object)"Setting new XalanTraceListener");
        this.currentTraceListener = currentTraceListener;
    }
}

