/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.breakpoint;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifierImpl;
import org.eclipse.datatools.sqltools.debugger.breakpoint.ISPBreakpoint;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerCorePlugin;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerMessages;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugModelUtil;
import org.eclipse.datatools.sqltools.routineeditor.util.RoutineEditorConstants;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.LineBreakpoint;

public class SPLineBreakpoint
extends LineBreakpoint
implements ISPBreakpoint {
    public static final String MARKER_TYPE = String.valueOf(DebuggerCorePlugin.PLUGIN_ID) + ".ui.spLineBreakpointMarker";
    static final String ATTR_CONDITION = String.valueOf(DebuggerCorePlugin.PLUGIN_ID) + ".condition";
    static final String ATTR_CONDITIONENABLED = String.valueOf(DebuggerCorePlugin.PLUGIN_ID) + ".conditionEnabled";

    public SPLineBreakpoint() {
    }

    public SPLineBreakpoint(final ProcIdentifier procId, final int lineNumber, final boolean enabled) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                SPLineBreakpoint.this.setMarker(ResourcesPlugin.getWorkspace().getRoot().createMarker(MARKER_TYPE));
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("org.eclipse.debug.core.id", SPDebugModelUtil.getModelIdentifier());
                attributes.put("org.eclipse.debug.core.enabled", enabled);
                attributes.put("lineNumber", lineNumber);
                attributes.put("charStart", -1);
                attributes.put("charEnd", -1);
                attributes.put(RoutineEditorConstants.ATTR_PROCIDENTIFIER, procId.encode());
                SPLineBreakpoint.this.ensureMarker().setAttributes(attributes);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 0, null);
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }

    public void setConditionEnabled(boolean enabled) throws CoreException {
        if (enabled != this.isConditionEnabled()) {
            this.setAttribute(ATTR_CONDITIONENABLED, enabled);
        }
    }

    public boolean isConditionEnabled() throws CoreException {
        return this.getMarker().getAttribute(ATTR_CONDITIONENABLED, false);
    }

    public String getCondition() {
        IMarker m = this.getMarker();
        return m.getAttribute(ATTR_CONDITION, null);
    }

    public void setCondition(String condition) throws CoreException {
        this.setAttribute(ATTR_CONDITION, condition);
    }

    public void setLineNumber(int number) throws CoreException {
        this.setAttribute("lineNumber", number);
    }

    public String getModelIdentifier() {
        return SPDebugModelUtil.getModelIdentifier();
    }

    @Override
    public ProcIdentifier getProcIdentifier() throws CoreException {
        IMarker m = this.getMarker();
        String name = m.getAttribute(RoutineEditorConstants.ATTR_PROCIDENTIFIER, "");
        if (name == null || name.length() == 0) {
            throw new CoreException((IStatus)new Status(4, DebuggerCorePlugin.PLUGIN_ID, 0, DebuggerMessages.SPLineBreakpoint_invalidProcIdentifier, null));
        }
        try {
            return ProcIdentifierImpl.decode((String)name);
        }
        catch (ParseException parseException) {
            throw new CoreException((IStatus)new Status(4, DebuggerCorePlugin.PLUGIN_ID, 0, String.valueOf(DebuggerMessages.SPLineBreakpoint_invalidProcIdentifier) + name, null));
        }
    }

    public String getEncodedProcIdentifier() throws CoreException {
        IMarker m = this.getMarker();
        String name = m.getAttribute(RoutineEditorConstants.ATTR_PROCIDENTIFIER, "");
        if (name == null || name.length() == 0) {
            throw new CoreException((IStatus)new Status(4, DebuggerCorePlugin.PLUGIN_ID, 0, DebuggerMessages.SPLineBreakpoint_invalidProcIdentifier, null));
        }
        return name;
    }

    public void setProcId(String encodedProc) throws CoreException {
        Map attris = this.ensureMarker().getAttributes();
        attris.remove(RoutineEditorConstants.ATTR_PROCIDENTIFIER);
        attris.put(RoutineEditorConstants.ATTR_PROCIDENTIFIER, encodedProc);
        this.ensureMarker().setAttributes(attris);
    }
}

