/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.conversion;

import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.runtime.Assert;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.wtp.internal.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenPluginUtils {
    private static final Logger log = LoggerFactory.getLogger(MavenPlugin.class);
    private static final String CONFIGURATION_KEY = "configuration";

    private MavenPluginUtils() {
    }

    private static Xpp3Dom getOrCreateConfiguration(Plugin plugin) {
        Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
        if (configuration == null) {
            configuration = new Xpp3Dom(CONFIGURATION_KEY);
            plugin.setConfiguration((Object)configuration);
        }
        return configuration;
    }

    public static void configure(Plugin plugin, String key, String value) {
        if (plugin == null) {
            return;
        }
        Xpp3Dom configuration = MavenPluginUtils.getOrCreateConfiguration(plugin);
        Xpp3Dom keyDom = configuration.getChild(key);
        if (keyDom == null) {
            keyDom = new Xpp3Dom(key);
            configuration.addChild(keyDom);
        }
        keyDom.setValue(value);
    }

    public static String getMostRecentPluginVersion(String groupId, String artifactId, String referenceVersion) {
        Assert.isNotNull((Object)groupId, (String)Messages.MavenPluginUtils_GroupId_Cant_Be_Null);
        Assert.isNotNull((Object)artifactId, (String)Messages.MavenPluginUtils_ArtifactId_Cant_Be_Null);
        return referenceVersion;
    }
}

