/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.transformer;

import java.util.Hashtable;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ViewSelectionTransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Tool;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.ToolManager;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.ListUDDIBusinessTool;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.ListUDDIServicesTool;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.ListWSDLServicesTool;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.ListWSILLinksTool;

public class WSILViewSelectionTransformer
extends ViewSelectionTransformer {
    public static final byte NONE = 0;
    public static final byte WSDL_SERVICE = 1;
    public static final byte UDDI_SERVICE = 2;
    public static final byte UDDI_BUSINESS = 3;
    public static final byte WSIL_LINK = 4;
    public static final byte FROM_TOOLID = 5;
    private byte type;

    public WSILViewSelectionTransformer(Controller controller) {
        this(controller, "", "viewId", 5);
    }

    public WSILViewSelectionTransformer(Controller controller, String listManagerKey, String viewKey, byte type) {
        super(controller, listManagerKey, viewKey);
        this.type = type;
    }

    @Override
    public Hashtable normalize(Hashtable properties) {
        Node currNode;
        if (this.type == 5 && (currNode = this.controller.getCurrentPerspective().getNodeManager().getSelectedNode()) != null) {
            try {
                int toolId = Integer.parseInt((String)properties.get("toolId"));
                ToolManager toolManager = currNode.getToolManager();
                Tool tool = toolManager.getTool(toolId);
                if (tool instanceof ListWSDLServicesTool) {
                    this.listManagerKey = "wsdlServices";
                } else if (tool instanceof ListUDDIServicesTool) {
                    this.listManagerKey = "uddiServices";
                } else if (tool instanceof ListUDDIBusinessTool) {
                    this.listManagerKey = "uddiLinks";
                } else if (tool instanceof ListWSILLinksTool) {
                    this.listManagerKey = "wsilLinks";
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return super.normalize(properties);
    }

    @Override
    public Hashtable deNormalize(Hashtable properties) {
        TreeElement currElement;
        Node currNode = this.controller.getCurrentPerspective().getNodeManager().getSelectedNode();
        if (currNode != null && (currElement = currNode.getTreeElement()) instanceof WsilElement) {
            WsilElement wsilElement = (WsilElement)currElement;
            switch (this.type) {
                case 1: {
                    wsilElement.getAllWSDLServices();
                    break;
                }
                case 2: {
                    wsilElement.getAllUDDIServices();
                    break;
                }
                case 3: {
                    wsilElement.getAllUDDILinks();
                    break;
                }
                case 4: {
                    wsilElement.getAllWSILLinks();
                    break;
                }
                case 5: {
                    try {
                        int toolId = Integer.parseInt((String)properties.get("toolId"));
                        ToolManager toolManager = currNode.getToolManager();
                        Tool tool = toolManager.getTool(toolId);
                        if (tool instanceof ListWSDLServicesTool) {
                            this.listManagerKey = "wsdlServices";
                            wsilElement.getAllWSDLServices();
                            break;
                        }
                        if (tool instanceof ListUDDIServicesTool) {
                            this.listManagerKey = "uddiServices";
                            wsilElement.getAllUDDIServices();
                            break;
                        }
                        if (tool instanceof ListUDDIBusinessTool) {
                            this.listManagerKey = "uddiLinks";
                            wsilElement.getAllUDDILinks();
                            break;
                        }
                        if (!(tool instanceof ListWSILLinksTool)) break;
                        this.listManagerKey = "wsilLinks";
                        wsilElement.getAllWSILLinks();
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
            }
        }
        return super.deNormalize(properties);
    }
}

