/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.ILogicalStructureTypeDelegate3;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewMessages;

public class LogicalStructureCache {
    private final Map<ILogicalStructureType, LogicalStructureTypeCache> fCacheForType = new HashMap<ILogicalStructureType, LogicalStructureTypeCache>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IValue getLogicalStructure(ILogicalStructureType type, IValue value) throws CoreException {
        Map<ILogicalStructureType, LogicalStructureTypeCache> map = this.fCacheForType;
        synchronized (map) {
            LogicalStructureTypeCache cache = this.getCacheForType(type);
            return cache.getLogicalStructure(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<LogicalStructureTypeCache> caches;
        Map<ILogicalStructureType, LogicalStructureTypeCache> map = this.fCacheForType;
        synchronized (map) {
            caches = new ArrayList<LogicalStructureTypeCache>(this.fCacheForType.values());
            this.fCacheForType.clear();
        }
        caches.forEach(LogicalStructureTypeCache::dispose);
    }

    protected LogicalStructureTypeCache getCacheForType(ILogicalStructureType type) {
        LogicalStructureTypeCache cache = this.fCacheForType.get(type);
        if (cache == null) {
            cache = new LogicalStructureTypeCache(type);
            this.fCacheForType.put(type, cache);
        }
        return cache;
    }

    class LogicalStructureTypeCache {
        private final ILogicalStructureType fType;
        private final Map<IValue, IValue> fKnownValues = new HashMap<IValue, IValue>();
        private final Set<IValue> fPendingValues = new HashSet<IValue>();

        public LogicalStructureTypeCache(ILogicalStructureType type) {
            this.fType = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IValue getLogicalStructure(IValue value) throws CoreException {
            Set<IValue> set;
            IValue iValue;
            Object object = this.fKnownValues;
            synchronized (object) {
                IValue logical = this.fKnownValues.get(value);
                if (logical != null) {
                    return logical;
                }
            }
            object = this.fPendingValues;
            synchronized (object) {
                if (this.fPendingValues.contains(value)) {
                    try {
                        this.fPendingValues.wait();
                        return this.getLogicalStructure(value);
                    }
                    catch (InterruptedException e) {
                        throw new CoreException((IStatus)new Status(8, DebugUIPlugin.getUniqueIdentifier(), VariablesViewMessages.LogicalStructureCache_0, (Throwable)e));
                    }
                }
                this.fPendingValues.add(value);
            }
            try {
                IValue result = this.fType.getLogicalStructure(value);
                Map<IValue, IValue> map = this.fKnownValues;
                synchronized (map) {
                    this.fKnownValues.put(value, result);
                }
                iValue = result;
                set = this.fPendingValues;
            }
            catch (Throwable throwable) {
                Set<IValue> set2 = this.fPendingValues;
                synchronized (set2) {
                    this.fPendingValues.remove(value);
                    this.fPendingValues.notifyAll();
                }
                throw throwable;
            }
            synchronized (set) {
                this.fPendingValues.remove(value);
                this.fPendingValues.notifyAll();
            }
            return iValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void dispose() {
            ILogicalStructureType iLogicalStructureType = this.fType;
            if (!(iLogicalStructureType instanceof ILogicalStructureTypeDelegate3)) {
                return;
            }
            ILogicalStructureTypeDelegate3 iLogicalStructureTypeDelegate3 = (ILogicalStructureTypeDelegate3)iLogicalStructureType;
            Map<IValue, IValue> map = this.fKnownValues;
            synchronized (map) {
                void typeDelegate;
                this.fKnownValues.values().forEach(arg_0 -> ((ILogicalStructureTypeDelegate3)typeDelegate).releaseValue(arg_0));
            }
        }
    }
}

