/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class TraceLogging {
    private int m_logLevel;
    private String m_logFileNamePrefix;
    private String m_logDirectory;
    private String m_logFormatterClass;
    private static HashMap<String, Integer> sm_logLevelLiterals = null;

    TraceLogging(IConfigurationElement traceLogging, String dataSourceElementId) throws OdaException {
        String logLevelString = traceLogging.getAttribute("logLevel");
        this.m_logLevel = TraceLogging.toLogLevelNumber(logLevelString);
        this.m_logFileNamePrefix = traceLogging.getAttribute("logFileNamePrefix");
        this.m_logDirectory = traceLogging.getAttribute("logDirectory");
        this.m_logFormatterClass = traceLogging.getAttribute("logFormatterClass");
    }

    public int getLogLevel() {
        return this.m_logLevel;
    }

    public String getLogFileNamePrefix() {
        return this.m_logFileNamePrefix;
    }

    public String getLogDirectory() {
        return this.m_logDirectory;
    }

    public String getLogFormatterClass() {
        return this.m_logFormatterClass;
    }

    public static int toLogLevelNumber(String logLevelName) {
        int defaultLogLevel = 900;
        if (logLevelName == null || logLevelName.length() == 0) {
            return defaultLogLevel;
        }
        Integer mappedLevel = TraceLogging.getLogLevelLiterals().get(logLevelName);
        if (mappedLevel != null) {
            return mappedLevel;
        }
        try {
            int logLevel = Short.parseShort(logLevelName);
            if (logLevel > 1000) {
                logLevel = Integer.MAX_VALUE;
            }
            return logLevel;
        }
        catch (NumberFormatException numberFormatException) {
            return defaultLogLevel;
        }
    }

    private static HashMap<String, Integer> getLogLevelLiterals() {
        if (sm_logLevelLiterals != null) {
            return sm_logLevelLiterals;
        }
        sm_logLevelLiterals = new HashMap(18, 1.0f);
        sm_logLevelLiterals.put("SEVERE", 1000);
        sm_logLevelLiterals.put("1000", 1000);
        sm_logLevelLiterals.put("WARNING", 900);
        sm_logLevelLiterals.put("900", 900);
        sm_logLevelLiterals.put("INFO", 800);
        sm_logLevelLiterals.put("800", 800);
        sm_logLevelLiterals.put("CONFIG", 700);
        sm_logLevelLiterals.put("700", 700);
        sm_logLevelLiterals.put("FINE", 500);
        sm_logLevelLiterals.put("500", 500);
        sm_logLevelLiterals.put("FINER", 400);
        sm_logLevelLiterals.put("400", 400);
        sm_logLevelLiterals.put("FINEST", 300);
        sm_logLevelLiterals.put("300", 300);
        sm_logLevelLiterals.put("ALL", Integer.MIN_VALUE);
        sm_logLevelLiterals.put("0", Integer.MIN_VALUE);
        sm_logLevelLiterals.put("OFF", Integer.MAX_VALUE);
        return sm_logLevelLiterals;
    }
}

