/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swtbot.generator.SWTBotGeneratorPlugin;
import org.eclipse.swtbot.generator.framework.Generator;
import org.eclipse.swtbot.generator.framework.IRecorderDialog;

public class GeneratorExtensionPointManager {
    private static final String GENERATOR_EXTENSION_POINT_ID = "org.eclipse.swtbot.generator.botGeneratorSupport";
    private static final String DIALOG_EXTENSION_POINT_ID = "org.eclipse.swtbot.generator.dialogSupport";

    public static List<Generator> loadGenerators() {
        ArrayList<Generator> res = new ArrayList<Generator>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(GENERATOR_EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            try {
                Generator generator = (Generator)ext.createExecutableExtension("class");
                res.add(generator);
            }
            catch (CoreException ex) {
                SWTBotGeneratorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.swtbot.generator", "Could not load generator", (Throwable)ex));
            }
            ++n2;
        }
        return res;
    }

    public static List<IRecorderDialog> loadDialogs() {
        ArrayList<IRecorderDialog> dialogs = new ArrayList<IRecorderDialog>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(DIALOG_EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            try {
                IRecorderDialog dialog = (IRecorderDialog)ext.createExecutableExtension("class");
                dialogs.add(dialog);
            }
            catch (CoreException ex) {
                SWTBotGeneratorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.swtbot.generator", "Could not load dialog", (Throwable)ex));
            }
            ++n2;
        }
        return dialogs;
    }
}

