/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.generators.xml2relaxng;

import java.util.Collection;
import java.util.SortedSet;
import org.eclipse.lemminx.extensions.generators.AbstractXML2GrammarGenerator;
import org.eclipse.lemminx.extensions.generators.AttributeDeclaration;
import org.eclipse.lemminx.extensions.generators.Cardinality;
import org.eclipse.lemminx.extensions.generators.ElementDeclaration;
import org.eclipse.lemminx.extensions.generators.Grammar;
import org.eclipse.lemminx.extensions.generators.xml2relaxng.RelaxNGGeneratorSettings;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLBuilder;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XML2RelaxNGGenerator
extends AbstractXML2GrammarGenerator<RelaxNGGeneratorSettings> {
    private static final String ELEMENT_ELT = "element";
    private static final String GRAMMAR_ELT = "grammar";
    private static final String START_ELT = "start";
    private static final String REF_ELT = "ref";
    private static final String DEFINE_ELT = "define";
    private static final String NAME_ATTR = "name";
    private static final String OPTIONAL_ELT = "optional";
    private static final String ONE_OR_MORE_ELT = "oneOrMore";
    private static final String TEXT_ELT = "text";
    private static final String CHOICE_ELT = "choice";
    private static final String ATTRIBUTE_ELT = "attribute";
    private static final String VALUE_ELT = "value";
    private static final String DATA_ELT = "data";
    private static final String TYPE_ATTR = "type";
    private static final String EMPTY_ELT = "empty";
    private static final String MIXED_ELT = "mixed";
    private static final String NAMESPACE_ATTR = "ns";
    private static final String DATATYPE_LIBRARY_ATTR = "datatypeLibrary";
    private static final String XML_SCHEMA_DATATYPES = "http://www.w3.org/2001/XMLSchema-datatypes";
    private static final String INTERLEAVE_ELT = "interleave";
    private static final String RELAXNG_NAMESPACE_URI = "http://relaxng.org/ns/structure/1.0";

    @Override
    protected void generate(Grammar grammar, RelaxNGGeneratorSettings settings, XMLBuilder schema, CancelChecker cancelChecker) {
        schema.startElement(null, GRAMMAR_ELT, false);
        schema.addSingleAttribute("xmlns", RELAXNG_NAMESPACE_URI, true);
        String targetNamespace = grammar.getDefaultNamespace();
        if (!StringUtils.isEmpty(targetNamespace)) {
            schema.addSingleAttribute(NAMESPACE_ATTR, targetNamespace, true);
        }
        schema.addSingleAttribute(DATATYPE_LIBRARY_ATTR, XML_SCHEMA_DATATYPES, true);
        schema.closeStartElement();
        ElementDeclaration rootElement = grammar.getElements().stream().findFirst().orElse(null);
        String rootElementName = rootElement == null ? "" : rootElement.getName();
        schema.startElement(null, START_ELT, true);
        schema.startElement(null, REF_ELT, false);
        schema.addSingleAttribute(NAME_ATTR, rootElementName + "Content", true);
        schema.selfCloseElement();
        schema.endElement(null, START_ELT);
        for (ElementDeclaration element : grammar.getElements()) {
            cancelChecker.checkCanceled();
            this.generateRngElement(schema, null, element, settings, rootElementName.equals(element.getName()), rootElementName + "Content", cancelChecker);
        }
        schema.endElement(null, GRAMMAR_ELT);
    }

    private void generateRngElement(XMLBuilder schema, String prefix, ElementDeclaration elementDecl, RelaxNGGeneratorSettings settings, boolean isRoot, String parentPatternName, CancelChecker cancelChecker) {
        Collection<ElementDeclaration> children = elementDecl.getElements();
        Collection<AttributeDeclaration> attributes = elementDecl.getAttributes();
        boolean hasChildren = !children.isEmpty();
        boolean hasAttributes = !attributes.isEmpty();
        boolean hasCharacterContent = elementDecl.hasCharacterContent();
        boolean mixedContent = hasChildren && hasCharacterContent;
        boolean isOneOrMore = false;
        String name = elementDecl.getName();
        boolean isOptionalElement = false;
        schema.startElement(null, DEFINE_ELT, false);
        schema.addSingleAttribute(NAME_ATTR, parentPatternName, true);
        schema.closeStartElement();
        schema.startElement(prefix, ELEMENT_ELT, false);
        schema.addSingleAttribute(NAME_ATTR, name, true);
        schema.closeStartElement();
        if (!hasChildren && !hasAttributes) {
            if (hasCharacterContent) {
                schema.startElement(prefix, TEXT_ELT, false);
                schema.selfCloseElement();
            } else {
                schema.startElement(prefix, EMPTY_ELT, false);
                schema.selfCloseElement();
            }
            schema.endElement(prefix, ELEMENT_ELT);
            schema.endElement(prefix, DEFINE_ELT);
        } else {
            if (mixedContent) {
                schema.startElement(prefix, MIXED_ELT, true);
            } else if (hasCharacterContent) {
                schema.startElement(prefix, TEXT_ELT, false);
                schema.selfCloseElement();
            }
            if (hasChildren) {
                boolean sequenced = elementDecl.getChildrenProperties().isSequenced();
                if (!sequenced) {
                    schema.startElement(prefix, INTERLEAVE_ELT, true);
                }
                for (ElementDeclaration child : children) {
                    Cardinality childCardinality;
                    String childName = child.getName();
                    Cardinality cardinality = childCardinality = elementDecl != null ? elementDecl.getChildrenProperties().getCardinalities().get(childName) : null;
                    if (childCardinality != null) {
                        if (childCardinality.getMin() == 0L) {
                            isOptionalElement = true;
                        } else if (childCardinality.getMax() > 1L) {
                            isOneOrMore = true;
                        }
                    }
                    if (isOptionalElement) {
                        schema.startElement(prefix, OPTIONAL_ELT, true);
                    } else if (isOneOrMore) {
                        schema.startElement(prefix, ONE_OR_MORE_ELT, true);
                    }
                    schema.startElement(null, REF_ELT, false);
                    schema.addSingleAttribute(NAME_ATTR, childName + "Content", true);
                    schema.selfCloseElement();
                    if (isOptionalElement) {
                        schema.endElement(prefix, OPTIONAL_ELT);
                        continue;
                    }
                    if (!isOneOrMore) continue;
                    schema.endElement(prefix, ONE_OR_MORE_ELT, true);
                }
                if (!sequenced) {
                    schema.endElement(prefix, INTERLEAVE_ELT);
                }
                if (mixedContent) {
                    schema.endElement(prefix, MIXED_ELT);
                }
                if (hasAttributes) {
                    this.generateAttribute(schema, attributes, prefix, settings, cancelChecker);
                }
                schema.endElement(prefix, ELEMENT_ELT);
                schema.endElement(prefix, DEFINE_ELT);
                for (ElementDeclaration child : children) {
                    this.generateRngElement(schema, prefix, child, settings, false, child.getName() + "Content", cancelChecker);
                }
            } else if (hasAttributes) {
                this.generateAttribute(schema, attributes, prefix, settings, cancelChecker);
                schema.endElement(prefix, ELEMENT_ELT);
                schema.endElement(prefix, DEFINE_ELT);
            }
        }
    }

    private void generateAttribute(XMLBuilder schema, Collection<AttributeDeclaration> attributes, String prefix, RelaxNGGeneratorSettings settings, CancelChecker cancelChecker) {
        for (AttributeDeclaration attribute : attributes) {
            String attrType = XML2RelaxNGGenerator.getRngType(attribute.getDataType());
            cancelChecker.checkCanceled();
            boolean required = attribute.isRequired();
            boolean fixed = attribute.isFixedValue(settings);
            boolean enums = attribute.isEnums(settings);
            if (!required) {
                schema.startElement(prefix, OPTIONAL_ELT, true);
            }
            schema.startElement(prefix, ATTRIBUTE_ELT, false);
            schema.addSingleAttribute(NAME_ATTR, attribute.getName(), true);
            if (enums && !fixed) {
                schema.closeStartElement();
                schema.startElement(prefix, CHOICE_ELT, true);
                SortedSet<String> values = attribute.getValues();
                for (String value : values) {
                    cancelChecker.checkCanceled();
                    schema.startElement(prefix, VALUE_ELT, true);
                    schema.addContent(value);
                    schema.endElement(prefix, VALUE_ELT);
                }
                schema.endElement(prefix, CHOICE_ELT);
                schema.endElement(prefix, ATTRIBUTE_ELT);
            } else if (fixed) {
                schema.closeStartElement();
                String value = attribute.getValues().stream().findFirst().orElse(null);
                cancelChecker.checkCanceled();
                schema.startElement(prefix, VALUE_ELT, true);
                schema.addContent(value);
                schema.endElement(prefix, VALUE_ELT);
                schema.endElement(prefix, ATTRIBUTE_ELT);
            } else if (attrType != null) {
                schema.closeStartElement();
                schema.startElement(prefix, DATA_ELT, false);
                schema.addSingleAttribute(TYPE_ATTR, attrType, true);
                schema.selfCloseElement();
                schema.endElement(prefix, ATTRIBUTE_ELT);
            } else {
                schema.selfCloseElement();
            }
            if (required) continue;
            schema.endElement(prefix, OPTIONAL_ELT);
        }
    }

    private static String getRngType(AttributeDeclaration.DataType dataType) {
        switch (dataType) {
            case DATE: {
                return "date";
            }
            case DATE_TIME: {
                return "dateTime";
            }
            case INTEGER: {
                return "integer";
            }
            case DECIMAL: {
                return "decimal";
            }
            case BOOLEAN: {
                return "boolean";
            }
        }
        return null;
    }

    @Override
    protected String getFileExtension() {
        return "rng";
    }
}

