/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.wizards.ctxhelp;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.build.BuildObject;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.text.bundle.BundleSymbolicNameHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ua.ui.wizards.ctxhelp.CtxWizardMessages;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class RegisterCtxHelpOperation
extends WorkspaceModifyOperation {
    static final String CTX_HELP_EXTENSION_POINT_ID = "org.eclipse.help.contexts";
    static final String CTX_HELP_PLUGIN_ID = "org.eclipse.help";
    public static final String CTX_HELP_ATTR_FILE = "file";
    public static final String CTX_HELP_ATTR_PLUGIN = "plugin";
    private final Shell fShell;
    private final String fPluginText;
    private final IProject fProject;
    private final String fResourceString;

    public RegisterCtxHelpOperation(Shell shell, IModel model, String pluginText) {
        this.fPluginText = pluginText;
        this.fProject = model.getUnderlyingResource().getProject();
        this.fResourceString = model.getUnderlyingResource().getProjectRelativePath().toPortableString();
        this.fShell = shell;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            boolean fragment = PluginRegistry.findModel((IProject)this.fProject).isFragmentModel();
            IFile file = this.fProject.getFile(fragment ? ICoreConstants.FRAGMENT_PATH : ICoreConstants.PLUGIN_PATH);
            if (file.exists()) {
                this.modifyExistingPluginFile(file, monitor);
            } else {
                this.createNewPluginFile(file, monitor);
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void modifyExistingPluginFile(IFile file, IProgressMonitor monitor) throws CoreException {
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)this.fShell);
        if (!status.isOK()) {
            throw new CoreException(Status.error((String)CtxWizardMessages.RegisterCtxHelpOperation_errorMessage1));
        }
        ModelModification mod = new ModelModification(this.fProject){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                RegisterCtxHelpOperation.this.doModifyPluginModel(model, monitor);
                RegisterCtxHelpOperation.this.doModifyManifestModel(model);
            }
        };
        PDEModelUtility.modifyModel((ModelModification)mod, (IProgressMonitor)monitor);
    }

    private void doModifyPluginModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
        if (!(model instanceof IPluginModelBase)) {
            return;
        }
        IPluginModelBase modelBase = (IPluginModelBase)model;
        IPluginExtension[] extensions = modelBase.getExtensions().getExtensions();
        IPluginExtension existingExtension = null;
        IPluginExtension[] iPluginExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            String point = extension.getPoint();
            if (CTX_HELP_EXTENSION_POINT_ID.equals(point)) {
                if (this.checkExistingExtensionElement(extension)) {
                    return;
                }
                existingExtension = extension;
            }
            ++n2;
        }
        if (existingExtension != null) {
            this.addElementToExtension(existingExtension);
        } else {
            this.addExtensionToModel(modelBase);
        }
    }

    private void doModifyManifestModel(IBaseModel model) {
        RequireBundleHeader require;
        BundleSymbolicNameHeader symbolic;
        if (!(model instanceof IBundlePluginModelBase)) {
            return;
        }
        IBundlePluginModelBase modelBase = (IBundlePluginModelBase)model;
        IBundle bundle = modelBase.getBundleModel().getBundle();
        IManifestHeader header = bundle.getManifestHeader("Bundle-SymbolicName");
        if (header instanceof BundleSymbolicNameHeader && !(symbolic = (BundleSymbolicNameHeader)header).isSingleton()) {
            symbolic.setSingleton(true);
        }
        if ((header = bundle.getManifestHeader("Require-Bundle")) instanceof RequireBundleHeader && !(require = (RequireBundleHeader)header).hasElement(CTX_HELP_PLUGIN_ID)) {
            require.addBundle(CTX_HELP_PLUGIN_ID);
        }
    }

    private void createNewPluginFile(IFile file, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CtxWizardMessages.RegisterCtxHelpOperation_task, 4);
        Object model = file.getProjectRelativePath().equals((Object)ICoreConstants.FRAGMENT_PATH) ? new WorkspaceFragmentModel(file, false) : new WorkspacePluginModel(file, false);
        monitor.worked(1);
        IPluginBase base = model.getPluginBase();
        base.setSchemaVersion(TargetPlatformHelper.getSchemaVersion());
        this.addExtensionToModel((IPluginModelBase)model);
        monitor.worked(1);
        model.save();
        monitor.worked(1);
        this.modifyExistingManifestFile(file);
        monitor.done();
    }

    private void modifyExistingManifestFile(IFile file) throws CoreException {
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)this.fShell);
        if (!status.isOK()) {
            throw new CoreException(Status.error((String)CtxWizardMessages.RegisterCtxHelpOperation_errorMessage2));
        }
        ModelModification mod = new ModelModification(this.fProject){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                RegisterCtxHelpOperation.this.doModifyManifestModel(model);
                RegisterCtxHelpOperation.this.doModifyBuildModel(model);
            }
        };
        PDEModelUtility.modifyModel((ModelModification)mod, null);
    }

    private void doModifyBuildModel(IBaseModel model) throws CoreException {
        IBuildModel buildModel;
        if (!(model instanceof IPluginModelBase)) {
            return;
        }
        IPluginModelBase modelBase = (IPluginModelBase)model;
        IBuild build = ClasspathUtilCore.getBuild((IPluginModelBase)modelBase);
        if (build == null) {
            return;
        }
        IBuildEntry entry = build.getEntry("bin.includes");
        if (entry == null) {
            return;
        }
        if (!entry.contains("plugin.xml")) {
            entry.addToken("plugin.xml");
        }
        if (build instanceof BuildObject && (buildModel = ((BuildObject)build).getModel()) instanceof WorkspaceBuildModel) {
            ((WorkspaceBuildModel)buildModel).save();
        }
    }

    private boolean checkExistingExtensionElement(IPluginExtension extension) {
        IPluginObject[] pluginObjects;
        IPluginObject[] iPluginObjectArray = pluginObjects = extension.getChildren();
        int n = pluginObjects.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginAttribute pluginAttribute;
            IPluginAttribute fileAttribute;
            IPluginElement element;
            IPluginObject pluginObject = iPluginObjectArray[n2];
            if (pluginObject instanceof IPluginElement && (element = (IPluginElement)pluginObject).getName().equals("contexts") && (fileAttribute = element.getAttribute(CTX_HELP_ATTR_FILE)) != null && PDETextHelper.isDefined((String)fileAttribute.getValue()) && this.fResourceString.equals(fileAttribute.getValue()) && ((pluginAttribute = element.getAttribute(CTX_HELP_ATTR_PLUGIN)) == null || !PDETextHelper.isDefined((String)pluginAttribute.getValue()) ? this.fPluginText.length() == 0 : this.fPluginText.equals(pluginAttribute.getValue()))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void addExtensionToModel(IPluginModelBase model) throws CoreException {
        IPluginExtension extension = model.getFactory().createExtension();
        extension.setPoint(CTX_HELP_EXTENSION_POINT_ID);
        this.addElementToExtension(extension);
        model.getPluginBase().add(extension);
    }

    private void addElementToExtension(IPluginExtension extension) throws CoreException {
        IPluginElement element = extension.getModel().getFactory().createElement((IPluginObject)extension);
        element.setName("contexts");
        element.setAttribute(CTX_HELP_ATTR_FILE, this.fResourceString);
        if (this.fPluginText.length() > 0) {
            element.setAttribute(CTX_HELP_ATTR_PLUGIN, this.fPluginText);
        }
        extension.add((IPluginObject)element);
    }
}

