/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.breakpointactions;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.breakpointactions.AbstractBreakpointAction;
import org.eclipse.cdt.debug.core.breakpointactions.ILogActionEnabler;
import org.eclipse.cdt.debug.ui.breakpointactions.Messages;
import org.eclipse.cdt.internal.core.XmlProcessorFactoryCdt;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class LogAction
extends AbstractBreakpointAction {
    private String message = "";
    private boolean evaluateExpression;
    private MessageConsole console;

    public boolean isEvaluateExpression() {
        return this.evaluateExpression;
    }

    public void setEvaluateExpression(boolean evaluateExpression) {
        this.evaluateExpression = evaluateExpression;
    }

    public IStatus execute(IBreakpoint breakpoint, IAdaptable context, IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        try {
            ILogActionEnabler enabler;
            this.openConsole(Messages.getString("LogAction.ConsoleTitle"));
            String logMessage = this.getMessage();
            if (this.isEvaluateExpression() && (enabler = (ILogActionEnabler)context.getAdapter(ILogActionEnabler.class)) != null) {
                logMessage = enabler.evaluateExpression(logMessage);
            }
            MessageConsoleStream stream = this.console.newMessageStream();
            stream.println(logMessage);
            stream.close();
        }
        catch (Exception e) {
            String errorMsg = MessageFormat.format(Messages.getString("LogAction.error.0"), this.getSummary());
            result = new Status(4, CDIDebugModel.getPluginIdentifier(), 10002, errorMsg, (Throwable)e);
        }
        return result;
    }

    private void openConsole(String consoleName) {
        boolean found = false;
        IConsole[] consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int i = 0;
        while (i < consoles.length) {
            if (consoleName.equals(consoles[i].getName())) {
                this.console = (MessageConsole)consoles[i];
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            this.console = new MessageConsole(consoleName, null);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
        }
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this.console);
    }

    public String getDefaultName() {
        return Messages.getString("LogAction.UntitledName");
    }

    public String getIdentifier() {
        return "org.eclipse.cdt.debug.ui.breakpointactions.LogAction";
    }

    public String getMemento() {
        String logData = "";
        try {
            DocumentBuilder docBuilder = XmlProcessorFactoryCdt.createDocumentBuilderWithErrorOnDOCTYPE();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("logData");
            rootElement.setAttribute("message", this.message);
            rootElement.setAttribute("evalExpr", Boolean.toString(this.evaluateExpression));
            doc.appendChild(rootElement);
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = XmlProcessorFactoryCdt.createTransformerFactoryWithErrorOnDOCTYPE();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            logData = s.toString("UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logData;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getSummary() {
        String summary = this.getMessage();
        if (summary.length() > 32) {
            summary = this.getMessage().substring(0, 32);
        }
        return summary;
    }

    public String getTypeName() {
        return Messages.getString("LogAction.TypeName");
    }

    public void initializeFromMemento(String data) {
        Element root = null;
        try {
            DocumentBuilder parser = XmlProcessorFactoryCdt.createDocumentBuilderWithErrorOnDOCTYPE();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(new InputSource(new StringReader(data))).getDocumentElement();
            String value = root.getAttribute("message");
            if (value == null) {
                throw new Exception();
            }
            this.message = value;
            value = root.getAttribute("evalExpr");
            if (value == null) {
                throw new Exception();
            }
            this.evaluateExpression = Boolean.valueOf(value);
            value = root.getAttribute("resume");
            if (value == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

