/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.conformance;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.internal.conformance.IJavaBeanProperty;
import org.eclipse.jst.ws.internal.conformance.IJavaWebServiceRule;
import org.eclipse.jst.ws.internal.conformance.IJavaWebServiceRuleEngine;

public class JavaWebServiceRuleSet {
    private Set enabledRules_ = new HashSet();
    private Set disabledRules_ = new HashSet();

    public JavaWebServiceRuleSet() {
    }

    public JavaWebServiceRuleSet(IJavaWebServiceRule[] rules) {
        this.addRules(rules);
    }

    public void addRule(IJavaWebServiceRule rule) {
        this.enabledRules_.add(rule);
    }

    public void addRules(IJavaWebServiceRule[] rules) {
        this.enabledRules_.addAll(Arrays.asList(rules));
    }

    public boolean setRuleDisabled(IJavaWebServiceRule rule, boolean disabled) {
        if (disabled) {
            if (this.enabledRules_.remove(rule)) {
                this.disabledRules_.add(rule);
                return true;
            }
        } else if (this.disabledRules_.remove(rule)) {
            this.enabledRules_.add(rule);
            return true;
        }
        return false;
    }

    public int size() {
        return this.enabledRules_.size() + this.disabledRules_.size();
    }

    public int numberEnabled() {
        return this.enabledRules_.size();
    }

    public int numberDisabled() {
        return this.disabledRules_.size();
    }

    public IJavaWebServiceRule[] getEnabledRules() {
        return this.enabledRules_.toArray(new IJavaWebServiceRule[0]);
    }

    public IJavaWebServiceRule[] getDisabledRules() {
        return this.disabledRules_.toArray(new IJavaWebServiceRule[0]);
    }

    public void init(IJavaWebServiceRuleEngine engine) {
        for (IJavaWebServiceRule rule : this.enabledRules_) {
            rule.init(engine);
        }
    }

    public void visitClass(IType jdtClass, Stack peanutTrail) {
        for (IJavaWebServiceRule rule : this.enabledRules_) {
            rule.visitClass(jdtClass, peanutTrail);
        }
    }

    public void visitException(IType jdtClass, Stack peanutTrail) {
        for (IJavaWebServiceRule rule : this.enabledRules_) {
            rule.visitException(jdtClass, peanutTrail);
        }
    }

    public void visitField(IField jdtField, Stack peanutTrail) {
        for (IJavaWebServiceRule rule : this.enabledRules_) {
            rule.visitField(jdtField, peanutTrail);
        }
    }

    public void visitProperty(IJavaBeanProperty beanProperty, Stack peanutTrail) {
        for (IJavaWebServiceRule rule : this.enabledRules_) {
            rule.visitProperty(beanProperty, peanutTrail);
        }
    }

    public void visitMethod(IMethod jdtMethod, Stack peanutTrail) {
        for (IJavaWebServiceRule rule : this.enabledRules_) {
            rule.visitMethod(jdtMethod, peanutTrail);
        }
    }

    public IStatus getResults(String rootMessage) {
        LinkedList<IStatus> list = new LinkedList<IStatus>();
        for (IJavaWebServiceRule rule : this.enabledRules_) {
            IStatus status = rule.getResults();
            if (status.isOK()) continue;
            list.add(status);
        }
        if (list.size() > 0) {
            MultiStatus multiStatus = new MultiStatus("org.eclipse.jst.ws", 0, rootMessage, null);
            for (IStatus status : list) {
                multiStatus.addAll(status);
            }
            return multiStatus;
        }
        return new Status(0, "org.eclipse.jst.ws", 0, "", null);
    }
}

