/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.dialogs;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.ui.ProfileImageRegistry;
import org.eclipse.datatools.connectivity.ui.actions.AddProfileViewAction;
import org.eclipse.datatools.connectivity.ui.actions.DeleteAction;
import org.eclipse.datatools.connectivity.ui.actions.ViewPropertyAction;
import org.eclipse.datatools.connectivity.ui.dse.DSEPlugin;
import org.eclipse.datatools.connectivity.ui.dse.dialogs.ConnectionDisplayProperty;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class ExistingConnectionProfilesDialogPage
extends DialogPage
implements Listener {
    private Button newConnectionButton;
    private Button editConnectionButton;
    private Button deleteConnectionButton;
    private Group existingConnectionsGroup;
    private TreeViewer existingConnectionsList;
    private Table connectionPropertiesTable;
    private boolean isShowProperties;
    private boolean isPropertiesSectionExpanded;

    protected ExistingConnectionProfilesDialogPage(boolean isShowProperties, boolean isPropertiesSectionExpanded) {
        this.isShowProperties = isShowProperties;
        this.isPropertiesSectionExpanded = isPropertiesSectionExpanded;
    }

    protected ExistingConnectionProfilesDialogPage(String title, boolean isShowProperties, boolean isPropertiesSectionExpanded) {
        super(title);
        this.isShowProperties = isShowProperties;
        this.isPropertiesSectionExpanded = isPropertiesSectionExpanded;
    }

    protected ExistingConnectionProfilesDialogPage(String title, ImageDescriptor image, boolean isShowProperties, boolean isPropertiesSectionExpanded) {
        super(title, image);
        this.isShowProperties = isShowProperties;
        this.isPropertiesSectionExpanded = isPropertiesSectionExpanded;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.existingConnectionsGroup = new Group(composite, 0);
        this.existingConnectionsGroup.setText(DSEPlugin.getDefault().getResourceString("ExistingConnectionsDialogPage.ExistingConnections.group"));
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        this.existingConnectionsGroup.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        this.existingConnectionsGroup.setLayoutData((Object)gd);
        Composite existingListComposite = new Composite((Composite)this.existingConnectionsGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        existingListComposite.setLayout((Layout)layout);
        existingListComposite.setLayoutData((Object)new GridData(1808));
        this.existingConnectionsList = new TreeViewer(existingListComposite, 2560);
        gd = new GridData(1808);
        this.existingConnectionsList.getTree().setLayoutData((Object)gd);
        Composite buttonComposite = new Composite(existingListComposite, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 0x1000008;
        gd.verticalAlignment = 128;
        buttonComposite.setLayoutData((Object)gd);
        this.newConnectionButton = new Button(buttonComposite, 0);
        this.newConnectionButton.setText(DSEPlugin.getDefault().getResourceString("ExistingConnectionsDialogPage.Button.new"));
        gd = new GridData();
        gd.widthHint = 80;
        gd.horizontalAlignment = 0x1000008;
        gd.verticalAlignment = 128;
        this.newConnectionButton.setLayoutData((Object)gd);
        this.editConnectionButton = new Button(buttonComposite, 0);
        this.editConnectionButton.setText(DSEPlugin.getDefault().getResourceString("ExistingConnectionsDialogPage.Button.edit"));
        gd = new GridData();
        gd.widthHint = 80;
        gd.horizontalAlignment = 0x1000008;
        gd.verticalAlignment = 128;
        this.editConnectionButton.setLayoutData((Object)gd);
        this.deleteConnectionButton = new Button(buttonComposite, 0);
        this.deleteConnectionButton.setText(DSEPlugin.getDefault().getResourceString("ExistingConnectionsDialogPage.Button.delete"));
        gd = new GridData();
        gd.widthHint = 80;
        gd.horizontalAlignment = 0x1000008;
        gd.verticalAlignment = 128;
        this.deleteConnectionButton.setLayoutData((Object)gd);
        if (this.isShowProperties) {
            ExpandableComposite expandableComposite = new ExpandableComposite((Composite)this.existingConnectionsGroup, 514);
            expandableComposite.setText(DSEPlugin.getDefault().getResourceString("ExistingConnectionsDialogPage.Properties.label"));
            expandableComposite.setExpanded(this.isPropertiesSectionExpanded);
            layout = new GridLayout();
            expandableComposite.setLayout((Layout)layout);
            gd = new GridData(1808);
            gd.minimumHeight = 170;
            expandableComposite.setLayoutData((Object)gd);
            if (expandableComposite.getVerticalBar() != null) {
                expandableComposite.getVerticalBar().setVisible(false);
            }
            if (expandableComposite.getHorizontalBar() != null) {
                expandableComposite.getHorizontalBar().setVisible(false);
            }
            this.connectionPropertiesTable = new Table((Composite)expandableComposite, 2048);
            gd = new GridData(1808);
            this.connectionPropertiesTable.setLayoutData((Object)gd);
            this.connectionPropertiesTable.setLinesVisible(true);
            this.connectionPropertiesTable.setHeaderVisible(true);
            expandableComposite.setClient((Control)this.connectionPropertiesTable);
            TableColumn tc1 = new TableColumn(this.connectionPropertiesTable, 0);
            tc1.setText(DSEPlugin.getDefault().getResourceString("ExistingConnectionsDialogPage.Property.columnHeader"));
            tc1.setResizable(true);
            tc1.setWidth(140);
            TableColumn tc2 = new TableColumn(this.connectionPropertiesTable, 0);
            tc2.setText(DSEPlugin.getDefault().getResourceString("ExistingConnectionsDialogPage.Value.columnHeader"));
            tc2.setResizable(true);
            tc2.setWidth(250);
        }
        this.initializeDialogUnits((Control)composite);
        this.newConnectionButton.addListener(13, (Listener)this);
        this.editConnectionButton.addListener(13, (Listener)this);
        this.deleteConnectionButton.addListener(13, (Listener)this);
        this.existingConnectionsList.getTree().addListener(13, (Listener)this);
        this.initializeValues();
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.newConnectionButton) {
            this.newConnection();
        } else if (source == this.editConnectionButton) {
            this.editConnection();
        } else if (source == this.deleteConnectionButton) {
            this.deleteConnection();
        } else if (source == this.existingConnectionsList.getTree()) {
            this.updateConnectionProperties();
            this.updateButtonEnablement();
        }
    }

    protected IConnectionProfile[] getConnectionsToDisplay() {
        return ProfileManager.getInstance().getProfiles(false);
    }

    protected void initializeValues() {
        this.existingConnectionsList.getTree().removeAll();
        IConnectionProfile[] connectionProfiles = this.getConnectionsToDisplay();
        if (connectionProfiles != null) {
            Hashtable<String, IConnectionProfile> existingConnections = new Hashtable<String, IConnectionProfile>();
            for (IConnectionProfile connection : Arrays.asList(connectionProfiles)) {
                existingConnections.put(connection.getName(), connection);
            }
            Object[] sortedNames = this.sortItems(existingConnections.keySet().toArray());
            int index = 0;
            while (index < sortedNames.length) {
                String name = (String)sortedNames[index];
                IConnectionProfile profile = (IConnectionProfile)existingConnections.get(name);
                TreeItem item = new TreeItem(this.existingConnectionsList.getTree(), 0);
                item.setText(name);
                item.setData(existingConnections.get(name));
                item.setImage(ProfileImageRegistry.getInstance().getProfileImage(profile.getProvider()));
                ++index;
            }
        }
        this.updateConnectionProperties();
        this.updateButtonEnablement();
    }

    private Object[] sortItems(Object[] names) {
        Arrays.sort(names, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                int result = -1;
                if (arg0 != null && arg1 != null) {
                    result = ((String)arg0).compareToIgnoreCase((String)arg1);
                }
                return result;
            }
        });
        return names;
    }

    private void updateButtonEnablement() {
        if (this.existingConnectionsList.getTree().getSelectionCount() > 0) {
            this.editConnectionButton.setEnabled(true);
            this.deleteConnectionButton.setEnabled(true);
        } else {
            this.editConnectionButton.setEnabled(false);
            this.deleteConnectionButton.setEnabled(false);
        }
    }

    private void updateConnectionProperties() {
        if (this.connectionPropertiesTable != null) {
            ConnectionDisplayProperty[] properties;
            IConnectionProfile selectedConnection;
            this.connectionPropertiesTable.removeAll();
            if (this.existingConnectionsList.getTree().getSelectionCount() > 0 && (selectedConnection = (IConnectionProfile)this.existingConnectionsList.getTree().getSelection()[0].getData()) != null && (properties = this.getConnectionDisplayProperties(selectedConnection)) != null) {
                int propertyCount = properties.length;
                int index = 0;
                while (index < propertyCount) {
                    TableItem tableItem = new TableItem(this.connectionPropertiesTable, 0);
                    tableItem.setText(new String[]{properties[index].getPropertyName(), properties[index].getValue()});
                    ++index;
                }
            }
        }
    }

    private ConnectionDisplayProperty[] getConnectionDisplayProperties(IConnectionProfile connectionProfile) {
        ConnectionDisplayProperty[] properties = null;
        Vector<ConnectionDisplayProperty> propertiesCollection = new Vector<ConnectionDisplayProperty>();
        propertiesCollection.add(new ConnectionDisplayProperty(DSEPlugin.getDefault().getResourceString("ExistingConnectionsDialogPage.PropertyName.name"), connectionProfile.getName()));
        propertiesCollection.add(new ConnectionDisplayProperty(DSEPlugin.getDefault().getResourceString("ExistingConnectionsDialogPage.PropertyName.description"), connectionProfile.getDescription()));
        propertiesCollection.add(new ConnectionDisplayProperty(DSEPlugin.getDefault().getResourceString("ExistingConnectionsDialogPage.PropertyName.category"), connectionProfile.getCategory().getName()));
        properties = new ConnectionDisplayProperty[propertiesCollection.size()];
        propertiesCollection.toArray(properties);
        properties = this.updateConnectionDisplayProperties(connectionProfile, properties);
        return properties;
    }

    protected ConnectionDisplayProperty[] updateConnectionDisplayProperties(IConnectionProfile connectionProfile, ConnectionDisplayProperty[] defaultDisplayProperties) {
        return defaultDisplayProperties;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initializeValues();
            this.existingConnectionsList.getTree().setFocus();
        }
    }

    public IConnectionProfile getSelectedConnection() {
        IConnectionProfile connection = null;
        if (this.existingConnectionsList.getTree().getSelectionCount() > 0) {
            connection = (IConnectionProfile)this.existingConnectionsList.getTree().getSelection()[0].getData();
        }
        return connection;
    }

    public void setDefaultConnection(String connectionName) {
        TreeItem[] items = this.existingConnectionsList.getTree().getItems();
        TreeItem foundItem = this.findTreeItemByName(items, connectionName);
        if (foundItem != null) {
            this.existingConnectionsList.getTree().setSelection(foundItem);
            this.updateConnectionProperties();
        }
    }

    private TreeItem findTreeItemByName(TreeItem[] items, String name) {
        TreeItem result = null;
        int index = 0;
        while (index < items.length) {
            if (name.equals(items[index].getText())) {
                result = items[index];
                break;
            }
            ++index;
        }
        return result;
    }

    protected void newConnection() {
        AddProfileViewAction newConnectionProfileAction = new AddProfileViewAction(null);
        newConnectionProfileAction.selectionChanged(null, null);
        newConnectionProfileAction.run(null);
        this.initializeValues();
    }

    private void editConnection() {
        ViewPropertyAction editConnectionProfileAction = new ViewPropertyAction((Viewer)this.existingConnectionsList);
        editConnectionProfileAction.run();
        this.initializeValues();
    }

    private void deleteConnection() {
        DeleteAction deleteConnectionProfileAction = new DeleteAction();
        deleteConnectionProfileAction.selectionChanged((IAction)deleteConnectionProfileAction, this.existingConnectionsList.getSelection());
        deleteConnectionProfileAction.run();
        this.initializeValues();
    }
}

