/*
 * Decompiled with CFR 0.152.
 */
package lpg.lpgjavaruntime;

import lpg.lpgjavaruntime.Differ;
import lpg.lpgjavaruntime.LexStream;
import lpg.lpgjavaruntime.PrsStream;

public class DifferLines
extends Differ {
    public DifferLines(PrsStream newStream, PrsStream oldStream) {
        super(newStream, oldStream);
    }

    protected DifferLines() {
    }

    @Override
    public Differ.ILine[] getBuffer(PrsStream stream) {
        LexStream lex_stream = stream.getLexStream();
        Differ.ILine[] buffer = new Line[lex_stream.getLineCount() + 1];
        int token = 1;
        buffer[0] = new Line(stream, 0, 0);
        int line_no = 1;
        while (line_no < buffer.length) {
            int first_token = token;
            while (token < stream.getSize() && stream.getLine(token) == line_no) {
                ++token;
            }
            buffer[line_no] = new Line(stream, first_token, token);
            ++line_no;
        }
        return buffer;
    }

    void printLines(PrsStream prs_stream, int first_line, int last_line) {
        LexStream lex_stream = prs_stream.getLexStream();
        char[] buffer = lex_stream.getInputChars();
        int line_no = first_line;
        while (line_no <= last_line) {
            int start = lex_stream.getLineOffset(line_no - 1) + 1;
            int end = lex_stream.getLineOffset(line_no);
            String num = String.valueOf(line_no) + " ";
            int i = 0;
            while (i < 7 - num.length()) {
                System.out.print(' ');
                ++i;
            }
            String line = String.valueOf(num) + new String(buffer, start, end - start);
            System.out.println(line);
            ++line_no;
        }
    }

    @Override
    void outputInsert(Differ.Change element) {
        this.insertCount += element.getNewe() - element.getNews() + 1;
        System.out.println("Insert after " + this.oldStream.getFileName() + "," + this.oldBuffer[element.getOlde()].getStartLine() + " " + this.newStream.getFileName() + "," + this.newBuffer[element.getNews()].getStartLine() + (this.newBuffer[element.getNewe()].getEndLine() > this.newBuffer[element.getNews()].getStartLine() ? ".." + this.newBuffer[element.getNewe()].getEndLine() : "") + ":");
        this.printLines(this.newStream, this.newBuffer[element.getNews()].getStartLine(), this.newBuffer[element.getNewe()].getEndLine());
    }

    @Override
    void outputDelete(Differ.Change element) {
        this.deleteCount += element.getOlde() - element.getOlds() + 1;
        System.out.println("Delete after " + this.newStream.getFileName() + "," + this.newBuffer[element.getNewe()].getStartLine() + " " + this.oldStream.getFileName() + "," + this.oldBuffer[element.getOlds()].getStartLine() + (this.oldBuffer[element.getOlde()].getEndLine() > this.oldBuffer[element.getOlds()].getStartLine() ? ".." + this.oldBuffer[element.getOlde()].getEndLine() : "") + ":");
        this.printLines(this.oldStream, this.oldBuffer[element.getOlds()].getStartLine(), this.oldBuffer[element.getOlde()].getEndLine());
    }

    @Override
    void outputReplace(Differ.Change element) {
        this.replaceDeleteCount += element.getOlde() - element.getOlds() + 1;
        this.replaceInsertCount += element.getNewe() - element.getNews() + 1;
        System.out.println("Replace " + this.oldStream.getFileName() + "," + this.oldBuffer[element.getOlds()].getStartLine() + (this.oldBuffer[element.getOlde()].getEndLine() > this.oldBuffer[element.getOlds()].getStartLine() ? ".." + this.oldBuffer[element.getOlde()].getEndLine() : "") + ":");
        this.printLines(this.oldStream, this.oldBuffer[element.getOlds()].getStartLine(), this.oldBuffer[element.getOlde()].getEndLine());
        System.out.println("With " + this.newStream.getFileName() + "," + this.newBuffer[element.getNews()].getStartLine() + (this.newBuffer[element.getNewe()].getEndLine() > this.newBuffer[element.getNews()].getStartLine() ? ".." + this.newBuffer[element.getNewe()].getEndLine() : "") + ":");
        this.printLines(this.newStream, this.newBuffer[element.getNews()].getStartLine(), this.newBuffer[element.getNewe()].getEndLine());
    }

    @Override
    void outputMove(Differ.Change element) {
        this.moveCount += element.getNewe() - element.getNews() + 1;
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldBuffer[element.getOlds()].getStartLine() + (this.oldBuffer[element.getOlde()].getEndLine() > this.oldBuffer[element.getOlds()].getStartLine() ? ".." + this.oldBuffer[element.getOlde()].getEndLine() : "") + " to " + this.newStream.getFileName() + "," + this.newBuffer[element.getNews()].getStartLine() + (this.newBuffer[element.getNewe()].getEndLine() > this.newBuffer[element.getNews()].getStartLine() ? ".." + this.newBuffer[element.getNewe()].getEndLine() : "") + ":");
        this.printLines(this.newStream, this.newBuffer[element.getNews()].getStartLine(), this.newBuffer[element.getNewe()].getEndLine());
    }

    @Override
    void outputMoveDelete(Differ.Change element) {
        this.moveCount += element.getNewe() - element.getNews() + 1;
        int bound = this.newBuffer[element.getNewe()].getEndLine() - this.newBuffer[element.getNews()].getStartLine();
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldBuffer[element.getOlds()].getStartLine() + (bound > 0 ? ".." + (this.oldBuffer[element.getOlds()].getStartLine() + bound) : "") + " to " + this.newStream.getFileName() + "," + this.newBuffer[element.getNews()].getStartLine() + (this.newBuffer[element.getNewe()].getEndLine() > this.newBuffer[element.getNews()].getStartLine() ? ".." + this.newBuffer[element.getNewe()].getEndLine() : "") + ":");
        this.printLines(this.newStream, this.newBuffer[element.getNews()].getStartLine(), this.newBuffer[element.getNewe()].getEndLine());
        int oldi = this.oldBuffer[element.getOlds()].getStartLine() + bound + 1;
        this.deleteCount += element.getOlde() - element.getOlds() - element.getNewe() + element.getNews();
        System.out.println("... And delete " + this.oldStream.getFileName() + "," + oldi + (this.oldBuffer[element.getOlde()].getEndLine() > oldi ? ".." + this.oldBuffer[element.getOlde()].getEndLine() : ""));
        this.printLines(this.oldStream, oldi, this.newBuffer[element.getOlde()].getEndLine());
    }

    @Override
    void outputMoveInsert(Differ.Change element) {
        this.moveCount += element.getOlde() - element.getOlds() + 1;
        int bound = this.oldBuffer[element.getOlde()].getStartLine() - this.oldBuffer[element.getOlds()].getEndLine();
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldBuffer[element.getOlds()].getStartLine() + (this.oldBuffer[element.getOlde()].getEndLine() > this.oldBuffer[element.getOlds()].getStartLine() ? ".." + this.oldBuffer[element.getOlde()].getEndLine() : "") + " to " + this.newStream.getFileName() + "," + this.newBuffer[element.getNews()].getStartLine() + (bound > 0 ? ".." + this.newBuffer[element.getNews()].getStartLine() + bound : "") + ":");
        this.printLines(this.newStream, this.newBuffer[element.getNews()].getStartLine(), this.newBuffer[element.getNews()].getStartLine() + bound);
        int newi = this.newBuffer[element.getNews()].getStartLine() + bound + 1;
        this.insertCount += element.getNewe() - element.getNews() - element.getOlde() + element.getOlds();
        System.out.println("... And insert " + this.newStream.getFileName() + "," + newi + (this.newBuffer[element.getNewe()].getEndLine() > newi ? ".." + this.newBuffer[element.getNewe()].getEndLine() : "") + ":");
        this.printLines(this.newStream, newi, this.newBuffer[element.getNewe()].getEndLine());
    }

    public class Line
    implements Differ.ILine {
        private int[] kind;
        private String[] name;
        private int hash_code;
        private int start_line;
        private int start_column;
        private int end_line;
        private int end_column;
        private int buffer_length;

        public Line(PrsStream stream, int start_token, int gate_token) {
            int size = gate_token > start_token ? gate_token - start_token : 0;
            int end_token = gate_token - 1;
            this.start_line = stream.getLine(start_token);
            this.start_column = stream.getColumn(start_token);
            if (size > 0) {
                this.end_line = stream.getEndLine(end_token);
                this.end_column = stream.getEndColumn(end_token);
            } else {
                this.end_line = stream.getLine(start_token);
                this.end_column = stream.getColumn(start_token);
            }
            this.kind = new int[size];
            this.name = new String[size];
            this.hash_code = size;
            int i = 0;
            while (i < size) {
                this.kind[i] = stream.getKind(start_token + i);
                this.name[i] = stream.getName(start_token + i);
                this.buffer_length += this.name[i].length() + 1;
                this.hash_code += this.kind[i];
                ++i;
            }
            this.hash_code += this.buffer_length;
        }

        @Override
        public final int size() {
            return this.kind.length;
        }

        @Override
        public final int hashCode() {
            return this.hash_code;
        }

        @Override
        public final boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof Line) {
                Line another_line = (Line)anObject;
                if (this.kind.length == another_line.kind.length) {
                    int i = 0;
                    while (i < this.kind.length) {
                        if (this.kind[i] != another_line.kind[i] || !this.name[i].equals(another_line.name[i])) break;
                        ++i;
                    }
                    return i == this.kind.length;
                }
            }
            return false;
        }

        @Override
        public final int getStartLine() {
            return this.start_line;
        }

        @Override
        public final int getStartColumn() {
            return this.start_column;
        }

        @Override
        public final int getEndLine() {
            return this.end_line;
        }

        @Override
        public final int getEndColumn() {
            return this.end_column;
        }

        public final String toString() {
            StringBuffer buffer = new StringBuffer(this.buffer_length);
            if (this.name.length > 0) {
                buffer.append(this.name[0]);
                int i = 1;
                while (i < this.name.length) {
                    buffer.append(" ");
                    buffer.append(this.name[i]);
                    ++i;
                }
            }
            return buffer.toString();
        }
    }
}

