/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations;

import java.util.List;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.Messages;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations.AbstractTrinidadTransformOperation;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.model.SelectItem;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.model.SelectItemModel;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SelectShuttleOperation
extends AbstractTrinidadTransformOperation {
    private static final String STYLECLASS_OUTERTABLE = "af_selectManyShuttle p_AFRequired";
    private static final String STYLECLASS_HEADER = "OraShuttleHeader";
    private static final String STYLECLASS_REQUIRED = "AFRequiredIconStyle";
    private static final String STYLECLASS_LISTCOLUMN = "af_selectManyShuttle_box-content";
    private static final String STYLECLASS_SELECT = "af_selectManyListbox_content";
    private static final String STYLECLASS_DESCRIPTION = "AFInstructionText";
    private static final String STYLECLASS_LINK = "OraLinkText";
    private static final String DEFAULT_SIZE = "10";
    private static final String[] LINKS_MOVE = new String[]{Messages.SelectShuttleOperation_LinkMove, Messages.SelectShuttleOperation_LinkMoveAll, Messages.SelectShuttleOperation_LinkRemove, Messages.SelectShuttleOperation_LinkRemoveAll};
    private static final String[] LINKS_ORDER = new String[]{Messages.SelectShuttleOperation_LinkTop, Messages.SelectShuttleOperation_LinkUp, Messages.SelectShuttleOperation_LinkDown, Messages.SelectShuttleOperation_LinkBottom};
    private boolean showOrderLinks;

    public Element transform(Element srcElement, Element curElement) {
        String styleClass;
        if (this.getParameters().length < 1) {
            this.getLog().error("Warning.TransformOperationFactory.TooFewParameters", this.getTransformOperationID());
            return null;
        }
        this.showOrderLinks = Boolean.parseBoolean(this.getParameters()[0]);
        Element outerTableElement = this.createElement("table");
        this.appendAttribute(outerTableElement, "cellpadding", "0");
        this.appendAttribute(outerTableElement, "cellspacing", "0");
        this.appendAttribute(outerTableElement, "border", "0");
        this.appendAttribute(outerTableElement, "width", "10%");
        String inlineStyle = srcElement.getAttribute("inlineStyle");
        if (inlineStyle != null && inlineStyle.length() > 0) {
            this.appendAttribute(outerTableElement, "style", inlineStyle);
        }
        if ((styleClass = srcElement.getAttribute("styleClass")) != null && styleClass.length() > 0) {
            this.appendAttribute(outerTableElement, "class", styleClass + " af_selectManyShuttle p_AFRequired");
        } else {
            this.appendAttribute(outerTableElement, "class", STYLECLASS_OUTERTABLE);
        }
        Element trHeaderElement = this.appendChildElement("tr", outerTableElement);
        Element tdLeadingHeaderElement = this.appendChildElement("td", trHeaderElement);
        String leadingHeader = srcElement.getAttribute("leadingHeader");
        if (leadingHeader != null && leadingHeader.length() > 0) {
            this.appendAttribute(tdLeadingHeaderElement, "class", STYLECLASS_HEADER);
            this.appendAttribute(tdLeadingHeaderElement, "valign", "bottom");
            this.appendChildText(leadingHeader, tdLeadingHeaderElement);
        }
        this.appendChildElement("td", trHeaderElement);
        Element tdTrailingHeaderElement = this.appendChildElement("td", trHeaderElement);
        String required = srcElement.getAttribute("required");
        String trailingHeader = srcElement.getAttribute("trailingHeader");
        if (required != null && Boolean.parseBoolean(required) || trailingHeader != null && trailingHeader.length() > 0) {
            this.appendAttribute(tdTrailingHeaderElement, "class", STYLECLASS_HEADER);
            this.appendAttribute(tdTrailingHeaderElement, "valign", "bottom");
            if (required != null && Boolean.parseBoolean(required)) {
                Element spanRequiredElement = this.appendChildElement("span", tdTrailingHeaderElement);
                this.appendAttribute(spanRequiredElement, "class", STYLECLASS_REQUIRED);
                this.appendChildText("*", spanRequiredElement);
            }
            if (trailingHeader != null && trailingHeader.length() > 0) {
                this.appendChildText(trailingHeader, tdTrailingHeaderElement);
            }
        }
        Element trContentElement = this.appendChildElement("tr", outerTableElement);
        this.buildListColumn(srcElement, trContentElement, true);
        this.buildLinkColumn(trContentElement, LINKS_MOVE);
        this.buildListColumn(srcElement, trContentElement, false);
        return outerTableElement;
    }

    private void buildListColumn(Element srcElement, Element parentElement, boolean isLeadingColumn) {
        String footerFacetName;
        Element footerFacet;
        Element filterFacet;
        Element tdElement0 = this.appendChildElement("td", parentElement);
        Element tableElement0 = this.appendChildElement("table", tdElement0);
        this.appendAttribute(tableElement0, "style", "width:100%;");
        this.appendAttribute(tableElement0, "cellpadding", "0");
        this.appendAttribute(tableElement0, "cellspacing", "0");
        this.appendAttribute(tableElement0, "border", "0");
        Element tbodyElement0 = this.appendChildElement("tbody", tableElement0);
        Element trElement0 = this.appendChildElement("tr", tbodyElement0);
        Element tdElement1 = this.appendChildElement("td", trElement0);
        Element divElement0 = this.appendChildElement("div", tdElement1);
        this.appendAttribute(divElement0, "class", STYLECLASS_LISTCOLUMN);
        Element tableElement1 = this.appendChildElement("table", divElement0);
        this.appendAttribute(tableElement1, "cellpadding", "0");
        this.appendAttribute(tableElement1, "border", "0");
        if (isLeadingColumn && (filterFacet = this.getChildFacetByName(srcElement, "filter")) != null) {
            Element trFilterElement = this.appendChildElement("tr", tableElement1);
            Element tdFilterElement = this.appendChildElement("td", trFilterElement);
            this.appendAttribute(tdFilterElement, "nowrap", "");
            this.appendAttribute(tdFilterElement, "valign", "middle");
            this.appendAttribute(tdFilterElement, "colspan", "3");
            this.tagConverterContext.addChild((Node)filterFacet, new ConvertPosition((Node)tdFilterElement, 0));
        }
        Element trSelectElement = this.appendChildElement("tr", tableElement1);
        Element tdSelectElement = this.appendChildElement("td", trSelectElement);
        this.appendAttribute(tdSelectElement, "nowrap", "");
        this.appendAttribute(tdSelectElement, "valign", "middle");
        Element spanSelectElement = this.appendChildElement("span", tdSelectElement);
        Element selectElement = this.appendChildElement("select", spanSelectElement);
        this.appendAttribute(selectElement, "multiple", "");
        this.appendAttribute(selectElement, "class", STYLECLASS_SELECT);
        this.appendAttribute(selectElement, "size", this.getSizeString(srcElement));
        if (isLeadingColumn) {
            List<SelectItem> selectItems = SelectItemModel.getModel(srcElement);
            for (SelectItem selectItem : selectItems) {
                Element optionElement = this.appendChildElement("option", selectElement);
                this.appendChildText(selectItem.getLabel(), optionElement);
            }
        }
        Element optionElement = this.appendChildElement("option", selectElement);
        this.appendChildText("_______________", optionElement);
        if (!isLeadingColumn && this.showOrderLinks) {
            this.buildLinkColumn(trSelectElement, LINKS_ORDER);
        }
        boolean showDesc = false;
        String showDescAttrName = isLeadingColumn ? "leadingDescShown" : "trailingDescShown";
        String showDescAttr = srcElement.getAttribute(showDescAttrName);
        if (showDescAttr != null && showDescAttr.length() > 0) {
            showDesc = Boolean.parseBoolean(showDescAttr);
        }
        if (showDesc) {
            Element trDescElement = this.appendChildElement("tr", tableElement1);
            Element tdDescElement = this.appendChildElement("td", trDescElement);
            this.appendAttribute(tdDescElement, "nowrap", "");
            this.appendAttribute(tdDescElement, "valign", "middle");
            this.appendAttribute(tdDescElement, "colspan", "3");
            Element spanDescElement = this.appendChildElement("span", tdDescElement);
            this.appendAttribute(spanDescElement, "class", STYLECLASS_DESCRIPTION);
            this.appendChildText(Messages.SelectShuttleOperation_Description, spanDescElement);
            this.appendChildElement("div", tdDescElement);
            Element textareaElement = this.appendChildElement("textarea", tdDescElement);
            this.appendAttribute(textareaElement, "rows", "2");
            this.appendAttribute(textareaElement, "cols", "18");
            this.appendAttribute(textareaElement, "readonly", "");
        }
        if ((footerFacet = this.getChildFacetByName(srcElement, footerFacetName = isLeadingColumn ? "leadingFooter" : "trailingFooter")) != null) {
            Element trFooterElement = this.appendChildElement("tr", tableElement1);
            Element tdFooterElement = this.appendChildElement("td", trFooterElement);
            this.appendAttribute(tdFooterElement, "nowrap", "");
            this.appendAttribute(tdFooterElement, "valign", "middle");
            this.appendAttribute(tdFooterElement, "colspan", "3");
            this.tagConverterContext.addChild((Node)footerFacet, new ConvertPosition((Node)tdFooterElement, 0));
        }
    }

    private void buildLinkColumn(Element parentElement, String[] linkText) {
        Element tdElement = this.appendChildElement("td", parentElement);
        this.appendAttribute(tdElement, "align", "center");
        this.appendAttribute(tdElement, "valign", "middle");
        this.appendAttribute(tdElement, "nowrap", "");
        this.appendAttribute(tdElement, "style", "padding:5px;");
        int i = 0;
        while (i < linkText.length) {
            Element aElement = this.appendChildElement("a", tdElement);
            this.appendAttribute(aElement, "href", "#");
            this.appendAttribute(aElement, "class", STYLECLASS_LINK);
            this.appendChildText(linkText[i], aElement);
            if (i < linkText.length - 1) {
                this.appendChildElement("br", tdElement);
            }
            ++i;
        }
    }

    private String getSizeString(Element srcElement) {
        String size = DEFAULT_SIZE;
        String sizeAttr = srcElement.getAttribute("size");
        if (sizeAttr != null && sizeAttr.length() > 0) {
            try {
                int iSize = Integer.parseInt(sizeAttr);
                iSize = Math.max(iSize, 10);
                iSize = Math.min(iSize, 20);
                size = String.valueOf(iSize);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return size;
    }
}

