/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.spi.factories;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.reviews.core.spi.remote.review.IReviewRemoteFactoryProvider;
import org.eclipse.mylyn.reviews.ui.spi.editor.AbstractReviewSection;
import org.eclipse.mylyn.reviews.ui.spi.factories.IUiContext;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractUiFactory<EObjectType>
implements IUiContext {
    String name;
    private final EObjectType object;
    private final IUiContext context;
    private Button button;

    public AbstractUiFactory(String name, IUiContext context, EObjectType object) {
        this.context = context;
        this.name = name;
        this.object = object;
    }

    public Control createControl(IUiContext context, Composite parent, FormToolkit toolkit) {
        this.button = toolkit.createButton(parent, this.name, 8);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractUiFactory.this.handleExecute();
            }
        });
        this.button.setEnabled(!this.isExecutableStateKnown() || this.isExecutable());
        return this.button;
    }

    private void handleExecute() {
        if (this.isExecutableStateKnown()) {
            this.execute();
        } else {
            this.handleExecutionStateError();
        }
    }

    protected void handleExecutionStateError() {
        String message = NLS.bind((String)"Cannot {0}. Try re-synchronizing the review task. If that fails, there may be a problem with your repository connection.", (Object)StringUtils.removeEnd((String)this.name, (String)"..."));
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", message), 3);
    }

    protected abstract boolean isExecutableStateKnown();

    public abstract boolean isExecutable();

    public abstract void execute();

    public EObjectType getModelObject() {
        return this.object;
    }

    @Override
    public Shell getShell() {
        return this.context.getShell();
    }

    @Override
    public ITask getTask() {
        return this.context.getTask();
    }

    @Override
    public TaskData getTaskData() {
        return this.context.getTaskData();
    }

    @Override
    public TaskEditor getEditor() {
        return this.context.getEditor();
    }

    @Override
    public TaskRepository getTaskRepository() {
        return this.context.getTaskRepository();
    }

    @Override
    public IReviewRemoteFactoryProvider getFactoryProvider() {
        return this.context.getFactoryProvider();
    }

    public IUiContext getContext() {
        return this.context;
    }

    public AbstractTaskEditorPage getTaskEditorPage() {
        if (this.getContext() instanceof AbstractTaskEditorPage) {
            return (AbstractTaskEditorPage)this.getContext();
        }
        if (this.getContext() instanceof AbstractReviewSection) {
            return ((AbstractReviewSection)this.getContext()).getReviewEditorPage();
        }
        return null;
    }
}

