/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.codegen.jet.JETAttributeListItem;
import org.eclipse.emf.codegen.jet.JETCommentItem;
import org.eclipse.emf.codegen.jet.JETCoreElement;
import org.eclipse.emf.codegen.jet.JETDirectiveItem;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETExpressionItem;
import org.eclipse.emf.codegen.jet.JETItem;
import org.eclipse.emf.codegen.jet.JETLiteralItem;
import org.eclipse.emf.codegen.jet.JETMark;
import org.eclipse.emf.codegen.jet.JETParseEventListener;
import org.eclipse.emf.codegen.jet.JETProblemListener;
import org.eclipse.emf.codegen.jet.JETReader;
import org.eclipse.emf.codegen.jet.JETRootItem;
import org.eclipse.emf.codegen.jet.JETScriptletItem;
import org.eclipse.emf.codegen.jet.JETSubItem;

public class JETParser {
    protected JETReader reader;
    protected JETParseEventListener listener;
    protected JETProblemListener problemListener;
    protected CharArrayWriter writer;
    protected JETMark writerStart;
    protected JETMark writerStop;
    protected final List<JETMark> writerFileTransitions = new ArrayList<JETMark>();
    protected List<JETCoreElement> coreElements = new ArrayList<JETCoreElement>();
    protected String openDirective = "<%@";
    protected String closeDirective = "%>";
    protected String openScriptlet = "<%";
    protected String closeScriptlet = "%>";
    protected String openExpr = "<%=";
    protected String closeExpr = "%>";
    protected String quotedStartTag = "<\\%";
    protected String quotedEndTag = "%\\>";
    protected String startTag = "<%";
    protected String endTag = "%>";
    protected String openComment = "<%-";
    protected String closeComment = "-%>";

    @Deprecated
    public JETParser(JETReader reader, JETParseEventListener parseEventListener, JETCoreElement[] coreElements) {
        this(reader, parseEventListener, coreElements, new JETProblemListener());
    }

    public JETParser(JETReader reader, JETParseEventListener parseEventListener, JETCoreElement[] coreElements, JETProblemListener problemListener) {
        this.reader = reader;
        this.problemListener = problemListener;
        this.listener = new DelegatingListener(parseEventListener, new Action(){

            @Override
            public void execute() throws JETException {
                JETParser.this.flushCharData();
            }
        });
        this.writer = new CharArrayWriter();
        int i = 0;
        while (i < coreElements.length) {
            this.coreElements.add(coreElements[i]);
            ++i;
        }
    }

    public JETProblemListener getProblemListener() {
        return this.problemListener;
    }

    public JETReader getReader() {
        return this.reader;
    }

    public void setStartTag(String tag) {
        this.openScriptlet = tag;
        this.openExpr = String.valueOf(tag) + "=";
        this.openDirective = String.valueOf(tag) + "@";
        this.openComment = String.valueOf(tag) + "-";
        this.quotedStartTag = String.valueOf(tag.charAt(0)) + "\\" + tag.charAt(1);
        this.startTag = tag;
        this.reader.setStartTag(tag);
    }

    public void setEndTag(String tag) {
        this.closeScriptlet = tag;
        this.closeExpr = tag;
        this.closeDirective = tag;
        this.closeComment = "-" + tag;
        this.quotedEndTag = String.valueOf(tag.charAt(0)) + "\\" + tag.charAt(1);
        this.endTag = tag;
        this.reader.setEndTag(tag);
    }

    public String getOpenComment() {
        return this.openComment;
    }

    public String getCloseComment() {
        return this.closeComment;
    }

    public String getOpenScriptlet() {
        return this.openScriptlet;
    }

    public String getCloseScriptlet() {
        return this.closeScriptlet;
    }

    public String getOpenExpr() {
        return this.openExpr;
    }

    public String getCloseExpr() {
        return this.closeExpr;
    }

    public String getOpenDirective() {
        return this.openDirective;
    }

    public String getCloseDirective() {
        return this.closeDirective;
    }

    public String getQuotedStartTag() {
        return this.quotedStartTag;
    }

    public String getQuotedEndTag() {
        return this.quotedEndTag;
    }

    public String getStartTag() {
        return this.startTag;
    }

    public String getEndTag() {
        return this.endTag;
    }

    protected void flushCharData() throws JETException {
        char[] array = this.writer.toCharArray();
        if (array.length != 0) {
            JETLiteralItem jetLiteralItem = new JETLiteralItem(this.writerStart, this.writerStop, this.writerFileTransitions);
            this.reader.pushItem(jetLiteralItem);
            this.listener.handleCharData(array);
            this.writer = new CharArrayWriter();
        }
        this.writerStop = null;
        this.writerStart = null;
        this.writerFileTransitions.clear();
    }

    public void parse() throws JETException {
        this.parse(null);
    }

    public void parse(String until) throws JETException {
        this.parse(until, null);
    }

    public void parse(String until, Class<?>[] accept) throws JETException {
        while (this.reader.hasMoreInput()) {
            JETCoreElement c;
            if (until != null && this.reader.matches(until)) {
                return;
            }
            Iterator<JETCoreElement> e = this.coreElements.iterator();
            if (accept != null) {
                ArrayList<JETCoreElement> v = new ArrayList<JETCoreElement>();
                while (e.hasNext()) {
                    c = e.next();
                    int i = 0;
                    while (i < accept.length) {
                        if (c.getClass().equals(accept[i])) {
                            v.add(c);
                        }
                        ++i;
                    }
                }
                e = v.iterator();
            }
            boolean accepted = false;
            while (e.hasNext()) {
                c = e.next();
                if (!c.accept(this.listener, this.reader, this)) continue;
                accepted = true;
                break;
            }
            if (accepted) continue;
            if (this.writerStart == null) {
                this.writerStart = this.reader.mark();
            }
            JETMark previousWriterStop = this.writerStop;
            JETMark newWriterStart = this.reader.mark();
            String s = this.reader.nextContent();
            this.writerStop = this.reader.mark();
            if (this.writerStop.getFileId() != this.writerStart.getFileId()) {
                Assert.isNotNull((Object)previousWriterStop, (String)"It should not be possible to transition to a new file if we didn't previously have a start/stop markers for the writer");
                if (!previousWriterStop.equals(newWriterStart)) {
                    this.writerFileTransitions.add(previousWriterStop);
                    this.writerFileTransitions.add(newWriterStart);
                }
            }
            this.writer.write(s, 0, s.length());
        }
        this.flushCharData();
    }

    public static JETDirectiveItem parseDirective(String directive) {
        try {
            JETReader reader = new JETReader("", new ByteArrayInputStream(directive.getBytes(StandardCharsets.UTF_8)), "UTF-8");
            JETParseEventListener parseEventListener = new JETParseEventListener(){

                @Override
                public void handleScriptlet(JETMark start, JETMark stop, Map<String, String> attributes) throws JETException {
                }

                @Override
                public void handleExpression(JETMark start, JETMark stop, Map<String, String> attributes) throws JETException {
                }

                @Override
                public void handleDirective(String directive, JETMark start, JETMark stop, Map<String, String> attributes) throws JETException {
                }

                @Override
                public void handleCharData(char[] chars) throws JETException {
                }

                @Override
                public void endPageProcessing() throws JETException {
                }

                @Override
                public void beginPageProcessing() throws JETException {
                }
            };
            JETProblemListener problemListener = new JETProblemListener();
            JETParser parser = new JETParser(reader, parseEventListener, new JETCoreElement[]{new Directive()}, problemListener);
            parser.parse(null, null);
            return (JETDirectiveItem)reader.popItem();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<JETRootItem> parseRootItems(String content) {
        try {
            JETReader reader = new JETReader("", new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), "UTF-8");
            ArrayList<JETRootItem> result = new ArrayList<JETRootItem>();
            JETCoreElement[] coreElements = new JETCoreElement[]{new Directive(), new QuoteEscape(), new Comment(), new Expression(), new Scriptlet()};
            class Listener
            implements JETParseEventListener,
            JETParseEventListener.CommentListener {
                private final /* synthetic */ List val$result;
                private final /* synthetic */ JETReader val$reader;

                Listener(List list, JETReader jETReader) {
                    this.val$result = list;
                    this.val$reader = jETReader;
                }

                @Override
                public void handleScriptlet(JETMark start, JETMark stop, Map<String, String> attributes) throws JETException {
                    JETScriptletItem jetScriptletItem = new JETScriptletItem(start, stop);
                    this.val$result.add(jetScriptletItem);
                }

                @Override
                public void handleExpression(JETMark start, JETMark stop, Map<String, String> attributes) throws JETException {
                    JETExpressionItem jetExpressionItem = new JETExpressionItem(start, stop);
                    this.val$result.add(jetExpressionItem);
                }

                @Override
                public void handleDirective(String directive, JETMark start, JETMark stop, Map<String, String> attributes) throws JETException {
                    this.handleItem();
                }

                @Override
                public void handleComment(JETMark start, JETMark stop) throws JETException {
                    JETCommentItem jetCommentItem = new JETCommentItem(start, stop);
                    this.val$result.add(jetCommentItem);
                }

                @Override
                public void handleCharData(char[] chars) throws JETException {
                    this.handleItem();
                }

                @Override
                public void endPageProcessing() throws JETException {
                }

                @Override
                public void beginPageProcessing() throws JETException {
                }

                private void handleItem() {
                    JETItem item = this.val$reader.popItem();
                    this.val$result.add((JETRootItem)item);
                }
            }
            JETParser parser = new JETParser(reader, new Listener(result, reader), coreElements, new JETProblemListener());
            parser.parse(null, null);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static interface Action {
        public void execute() throws JETException;
    }

    public static class Comment
    implements JETCoreElement {
        @Override
        public boolean accept(JETParseEventListener listener, JETReader reader, JETParser parser) throws JETException {
            if (!reader.matches(parser.getOpenComment())) {
                return false;
            }
            String open = parser.getOpenComment();
            String close = parser.getCloseComment();
            reader.advance(open.length());
            JETMark start = reader.mark();
            JETMark stop = reader.skipUntil(close);
            if (stop == null) {
                stop = reader.mark();
                parser.getProblemListener().handleProblem(start, start, 4, null, "jet.error.unterminated", open, start.format("jet.mark.file.line.column"));
            }
            if (listener instanceof JETParseEventListener.CommentListener) {
                ((JETParseEventListener.CommentListener)((Object)listener)).handleComment(start, stop);
            }
            return true;
        }
    }

    public static class DelegatingListener
    implements JETParseEventListener,
    JETParseEventListener.CommentListener {
        protected JETParseEventListener delegate;
        protected Action action;

        public DelegatingListener(JETParseEventListener delegate, Action action) {
            this.delegate = delegate;
            this.action = action;
        }

        public void doAction() throws JETException {
            this.action.execute();
        }

        @Override
        public void beginPageProcessing() throws JETException {
            this.delegate.beginPageProcessing();
        }

        @Override
        public void endPageProcessing() throws JETException {
            this.delegate.endPageProcessing();
        }

        @Override
        public void handleDirective(String directive, JETMark start, JETMark stop, Map<String, String> attrs) throws JETException {
            this.doAction();
            this.delegate.handleDirective(directive, start, stop, attrs);
        }

        @Override
        public void handleScriptlet(JETMark start, JETMark stop, Map<String, String> attrs) throws JETException {
            this.doAction();
            this.delegate.handleScriptlet(start, stop, attrs);
        }

        @Override
        public void handleExpression(JETMark start, JETMark stop, Map<String, String> attrs) throws JETException {
            this.doAction();
            this.delegate.handleExpression(start, stop, attrs);
        }

        @Override
        public void handleCharData(char[] chars) throws JETException {
            this.delegate.handleCharData(chars);
        }

        @Override
        public void handleComment(JETMark start, JETMark stop) throws JETException {
            this.doAction();
            if (this.delegate instanceof JETParseEventListener.CommentListener) {
                ((JETParseEventListener.CommentListener)((Object)this.delegate)).handleComment(start, stop);
            }
        }
    }

    public static class Directive
    implements JETCoreElement {
        protected Collection<String> directives = new ArrayList<String>();

        @Override
        public boolean accept(JETParseEventListener listener, JETReader reader, JETParser parser) throws JETException {
            String open = parser.getOpenDirective();
            if (reader.matches(open)) {
                JETMark directiveNameStop;
                JETMark start = reader.mark();
                reader.advance(open.length());
                reader.skipSpaces();
                String match = null;
                JETMark directiveNameStart = reader.mark();
                for (String directive : this.directives) {
                    if (!reader.matches(directive, true)) continue;
                    match = directive;
                    break;
                }
                if (match == null) {
                    while (Character.isLetterOrDigit(reader.peekChar())) {
                        reader.nextChar();
                    }
                    directiveNameStop = reader.mark();
                    char[] badDirectiveName = reader.getChars(directiveNameStart, directiveNameStop);
                    parser.getProblemListener().handleProblem(directiveNameStart, directiveNameStop, 2, null, "jet.error.bad.directive", new String(badDirectiveName), start.format("jet.mark.file.line.column"));
                    match = new String(badDirectiveName);
                } else {
                    reader.advance(match.length());
                }
                directiveNameStop = reader.mark();
                JETSubItem directiveName = new JETSubItem(directiveNameStart, directiveNameStop);
                HashMap<String, String> attrs = reader.parseTagAttributes();
                JETAttributeListItem attributeList = (JETAttributeListItem)reader.popItem();
                reader.skipSpaces();
                String close = parser.getCloseDirective();
                if (!reader.matches(close)) {
                    parser.getProblemListener().handleProblem(start, start, 4, null, "jet.error.unterminated", open, start.format("jet.mark.file.line.column"));
                } else {
                    reader.advance(close.length());
                }
                JETMark stop = reader.mark();
                reader.pushItem(new JETDirectiveItem(start, stop, directiveName, attributeList));
                listener.handleDirective(match, start, stop, attrs);
                return true;
            }
            return false;
        }

        public Collection<String> getDirectives() {
            return this.directives;
        }
    }

    public static class Expression
    implements JETCoreElement {
        @Override
        public boolean accept(JETParseEventListener listener, JETReader reader, JETParser parser) throws JETException {
            Map<String, String> attrs = null;
            if (!reader.matches(parser.getOpenExpr())) {
                return false;
            }
            String open = parser.getOpenExpr();
            String close = parser.getCloseExpr();
            reader.advance(open.length());
            JETMark start = reader.mark();
            JETMark stop = reader.skipUntil(close);
            if (stop == null) {
                stop = reader.mark();
                parser.getProblemListener().handleProblem(start, start, 4, null, "jet.error.unterminated", open, start.format("jet.mark.file.line.column"));
            }
            listener.handleExpression(start, stop, attrs);
            return true;
        }
    }

    public static class QuoteEscape
    implements JETCoreElement {
        protected static final String APOS = "&apos;";
        protected static final String QUOTE = "&quote;";

        @Override
        public boolean accept(JETParseEventListener listener, JETReader reader, JETParser parser) throws JETException {
            block6: {
                block5: {
                    try {
                        if (!reader.matches(parser.getQuotedEndTag())) break block5;
                        parser.writerStart = reader.mark();
                        reader.advance(parser.getQuotedEndTag().length());
                        parser.writer.write(parser.getEndTag());
                        parser.writerStop = reader.mark();
                        parser.flushCharData();
                        return true;
                    }
                    catch (IOException exception) {
                        throw new JETException(exception);
                    }
                }
                if (!reader.matches(APOS)) break block6;
                parser.writerStart = reader.mark();
                reader.advance(APOS.length());
                parser.writer.write("'");
                parser.flushCharData();
                parser.writerStop = reader.mark();
                return true;
            }
            if (reader.matches(QUOTE)) {
                parser.writerStart = reader.mark();
                reader.advance(QUOTE.length());
                parser.writer.write("\"");
                parser.flushCharData();
                parser.writerStop = reader.mark();
                return true;
            }
            return false;
        }
    }

    public static class Scriptlet
    implements JETCoreElement {
        @Override
        public boolean accept(JETParseEventListener listener, JETReader reader, JETParser parser) throws JETException {
            if (!reader.matches(parser.getOpenScriptlet())) {
                return false;
            }
            String open = parser.getOpenScriptlet();
            String close = parser.getCloseScriptlet();
            reader.advance(open.length());
            JETMark start = reader.mark();
            JETMark stop = reader.skipUntil(close);
            if (stop == null) {
                stop = reader.mark();
                parser.getProblemListener().handleProblem(start, start, 4, null, "jet.error.unterminated", open, start.format("jet.mark.file.line.column"));
            }
            listener.handleScriptlet(start, stop, null);
            return true;
        }
    }
}

