/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal;

import java.util.Objects;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcherExtension;
import org.eclipse.tm4e.languageconfiguration.internal.model.AutoClosingPair;
import org.eclipse.tm4e.languageconfiguration.internal.registry.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeHelper;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeInfo;

public class LanguageConfigurationCharacterPairMatcher
implements ICharacterPairMatcher,
ICharacterPairMatcherExtension {
    private static DefaultCharacterPairMatcher NOOP_MATCHER = new DefaultCharacterPairMatcher(new char[0]);
    private @Nullable DefaultCharacterPairMatcher matcher;
    private @Nullable IDocument document;

    public @Nullable IRegion match(IDocument document, int offset) {
        return this.getMatcher(document).match(document, offset);
    }

    public @Nullable IRegion match(IDocument document, int offset, int length) {
        return this.getMatcher(document).match(document, offset, length);
    }

    public int getAnchor() {
        return this.matcher != null ? this.matcher.getAnchor() : -1;
    }

    public @Nullable IRegion findEnclosingPeerCharacters(IDocument document, int offset, int length) {
        return this.getMatcher(document).findEnclosingPeerCharacters(document, offset, length);
    }

    public boolean isMatchedChar(char ch) {
        IDocument document = this.document;
        if (document == null) {
            return false;
        }
        return this.getMatcher(document).isMatchedChar(ch);
    }

    public boolean isMatchedChar(char ch, IDocument document, int offset) {
        return this.getMatcher(document).isMatchedChar(ch, document, offset);
    }

    public boolean isRecomputationOfEnclosingPairRequired(IDocument document, IRegion currentSelection, IRegion previousSelection) {
        return this.getMatcher(document).isRecomputationOfEnclosingPairRequired(document, currentSelection, previousSelection);
    }

    public void dispose() {
        if (this.matcher != null) {
            this.matcher.dispose();
        }
        this.matcher = null;
    }

    public void clear() {
        if (this.matcher != null) {
            this.matcher.clear();
        }
    }

    private DefaultCharacterPairMatcher getMatcher(IDocument document) {
        DefaultCharacterPairMatcher matcher = this.matcher;
        if (matcher == null || !document.equals(this.document)) {
            IContentType[] contentTypes;
            this.document = document;
            ContentTypeInfo info = ContentTypeHelper.findContentTypes((IDocument)document);
            IContentType[] iContentTypeArray = contentTypes = info == null ? null : info.getContentTypes();
            if (contentTypes == null || contentTypes.length == 0) {
                this.matcher = matcher = NOOP_MATCHER;
            } else {
                StringBuilder surroundingBracketsChars = new StringBuilder();
                StringBuilder surroundingQuotesChars = new StringBuilder();
                LanguageConfigurationRegistryManager registry = LanguageConfigurationRegistryManager.getInstance();
                IContentType[] iContentTypeArray2 = contentTypes;
                int n = contentTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IContentType contentType = iContentTypeArray2[n2];
                    if (registry.shouldSurroundingPairs(contentType)) {
                        for (AutoClosingPair surroundingPair : registry.getSurroundingPairs(contentType)) {
                            if (Objects.equals(surroundingPair.open, surroundingPair.close)) {
                                surroundingQuotesChars.append(surroundingPair.open);
                                continue;
                            }
                            surroundingBracketsChars.append(surroundingPair.open);
                            surroundingBracketsChars.append(surroundingPair.close);
                        }
                    }
                    ++n2;
                }
                if (surroundingBracketsChars.isEmpty() && surroundingQuotesChars.isEmpty()) {
                    this.matcher = matcher = NOOP_MATCHER;
                } else {
                    char[] bracketsChars = new char[surroundingBracketsChars.length()];
                    surroundingBracketsChars.getChars(0, surroundingBracketsChars.length(), bracketsChars, 0);
                    this.matcher = matcher = new DefaultCharacterPairMatcher(bracketsChars);
                }
            }
        }
        return matcher;
    }
}

