/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.egit.core.op.DiscardChangesOperation;
import org.eclipse.egit.core.util.RevCommitUtils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.ReplaceConflictActionHandler;
import org.eclipse.egit.ui.internal.selection.SelectionRepositoryStateCache;
import org.eclipse.egit.ui.internal.staging.StagingEntry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.actions.CompoundContributionItem;

public class ReplaceConflictMenu
extends CompoundContributionItem {
    private final Repository repo;
    private final Collection<StagingEntry> entries;

    public ReplaceConflictMenu(Repository repository, Collection<StagingEntry> entries) {
        this.repo = repository;
        this.entries = entries;
    }

    protected IContributionItem[] getContributionItems() {
        if (this.entries == null || this.entries.isEmpty()) {
            return new IContributionItem[0];
        }
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        RevCommit ours = SelectionRepositoryStateCache.INSTANCE.getHeadCommit(this.repo);
        if (ours != null) {
            items.add(ReplaceConflictMenu.createOursItem(ReplaceConflictActionHandler.formatCommitLabel(UIText.ReplaceWithOursTheirsMenu_OursWithCommitLabel, ours), this.repo, this.entries));
        } else {
            items.add(ReplaceConflictMenu.createOursItem(UIText.ReplaceWithOursTheirsMenu_OursWithoutCommitLabel, this.repo, this.entries));
        }
        RevCommit theirs = null;
        try {
            theirs = RevCommitUtils.getTheirs((Repository)this.repo);
        }
        catch (IOException e) {
            Activator.logError(e.getLocalizedMessage(), e);
        }
        if (theirs != null) {
            items.add(ReplaceConflictMenu.createTheirsItem(ReplaceConflictActionHandler.formatCommitLabel(UIText.ReplaceWithOursTheirsMenu_TheirsWithCommitLabel, theirs), this.repo, this.entries));
        } else {
            items.add(ReplaceConflictMenu.createTheirsItem(UIText.ReplaceWithOursTheirsMenu_TheirsWithoutCommitLabel, this.repo, this.entries));
        }
        return items.toArray(new IContributionItem[0]);
    }

    private static IContributionItem createOursItem(String label, Repository repository, Collection<StagingEntry> entries) {
        return new ActionContributionItem((IAction)new ReplaceAction(label, DiscardChangesOperation.Stage.OURS, repository, entries));
    }

    private static IContributionItem createTheirsItem(String label, Repository repository, Collection<StagingEntry> entries) {
        return new ActionContributionItem((IAction)new ReplaceAction(label, DiscardChangesOperation.Stage.THEIRS, repository, entries));
    }

    private static class ReplaceAction
    extends Action {
        private final DiscardChangesOperation.Stage stage;
        private final Repository repository;
        private final Collection<StagingEntry> entries;

        public ReplaceAction(String text, DiscardChangesOperation.Stage stage, Repository repository, Collection<StagingEntry> entries) {
            super(text);
            this.stage = stage;
            this.repository = repository;
            this.entries = entries;
        }

        public void run() {
            ArrayList<String> toCheckout = new ArrayList<String>();
            ArrayList<String> toRemove = new ArrayList<String>();
            for (StagingEntry entry : this.entries) {
                IndexDiff.StageState state = entry.getConflictType();
                if (IndexDiff.StageState.DELETED_BY_THEM == state && this.stage == DiscardChangesOperation.Stage.THEIRS || IndexDiff.StageState.DELETED_BY_US == state && this.stage == DiscardChangesOperation.Stage.OURS) {
                    toRemove.add(entry.getPath());
                    continue;
                }
                toCheckout.add(entry.getPath());
            }
            ReplaceConflictActionHandler.replaceWithStage(this.repository, this.stage, toCheckout, toRemove);
        }
    }
}

