/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ComponentDecorator;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ConverterDecorator;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.FacetDecorator;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ValidatorDecorator;
import org.eclipse.jst.jsf.common.ui.internal.form.AbstractXMLSectionsDetailsForm;
import org.eclipse.jst.jsf.ui.internal.common.ViewObjectPresenter;
import org.eclipse.jst.jsf.ui.internal.component.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

class ComponentInstanceDetailsForm
extends AbstractXMLSectionsDetailsForm {
    private static final String COMPONENT_SECTION_KEY = "componentSection";
    private static final String COMPONENT_TYPE_SECTION_KEY = "componentTypeSection";
    private static final String COMPONENT_INTERFACES_KEY = "componentInterfacesSection";
    private static final String COMPONENT_DECORATORS_KEY = "componentDecorators";
    private static final String COMPONENT_PROPERTIES_KEY = "componentProperties";
    private final LabelProvider _labelProvider = new MyLabelProvider();
    private AbstractXMLSectionsDetailsForm.XMLTextSection _componentTypeSection;
    private AbstractXMLSectionsDetailsForm.XMLTextSection _componentSection;
    private AbstractXMLSectionsDetailsForm.XMLTextSection _componentInterfacesSection;
    private AbstractXMLSectionsDetailsForm.XMLTextSection _componentDecoratorsSection;
    private AbstractXMLSectionsDetailsForm.XMLTextSection _componentPropertiesSection;

    ComponentInstanceDetailsForm() {
    }

    protected void doUpdateSelection(Object newSelection) {
        if (newSelection instanceof ComponentInfo) {
            ComponentInfo compInfo = (ComponentInfo)newSelection;
            this.updateComponentSection(compInfo);
            this.updateComponentDecoratorsSection(compInfo);
            this.updateComponentPropertiesSection(compInfo);
            ComponentTypeInfo typeInfo = compInfo.getComponentTypeInfo();
            if (typeInfo != null) {
                this.updateComponentTypeSection(typeInfo);
                this.updateComponentInterfacesSection(compInfo, typeInfo);
            }
        }
    }

    private void updateComponentSection(ComponentInfo compInfo) {
        String className = compInfo.getComponentTypeInfo().getClassName();
        String id = compInfo.getId();
        ComponentInfo parent = compInfo.getParent();
        ArrayList<ViewObjectPresenter.TitleValuePair> values = new ArrayList<ViewObjectPresenter.TitleValuePair>();
        values.add(new ViewObjectPresenter.TitleValuePair(Messages.ComponentInstanceDetailsForm_Name, className != null ? Signature.getSimpleName((String)className) : ""));
        values.add(new ViewObjectPresenter.TitleValuePair(Messages.ComponentInstanceDetailsForm_Id, id != null ? id : Messages.ComponentInstanceDetailsForm_None));
        values.add(new ViewObjectPresenter.TitleValuePair(Messages.ComponentInstanceDetailsForm_ParentId, parent != null && parent.getId() != null ? parent.getId() : Messages.ComponentInstanceDetailsForm_None));
        this._componentSection.setText(String.format("<form>%s</form>", ViewObjectPresenter.createLines(values)), true, false);
        this._componentSection.refresh();
    }

    private void updateComponentTypeSection(ComponentTypeInfo typeInfo) {
        this._componentTypeSection.setText(ViewObjectPresenter.present(typeInfo), true, false);
        this._componentTypeSection.refresh();
    }

    private void updateComponentInterfacesSection(ComponentInfo compInfo, ComponentTypeInfo typeInfo) {
        this._componentInterfacesSection.setText(ViewObjectPresenter.presentCompInterfaces(typeInfo, compInfo), true, false);
        this._componentInterfacesSection.refresh();
    }

    private void updateComponentDecoratorsSection(ComponentInfo compInfo) {
        ArrayList<ViewObjectPresenter.TitleValuePair> decoratorLines = new ArrayList<ViewObjectPresenter.TitleValuePair>();
        String text = "";
        for (ComponentDecorator decorator : compInfo.getAllDecorators()) {
            String labelText = this._labelProvider.getText((Object)decorator);
            if (labelText == null) continue;
            decoratorLines.add(new ViewObjectPresenter.TitleValuePair(null, labelText));
        }
        Collections.sort(decoratorLines);
        text = ViewObjectPresenter.createLines(decoratorLines);
        this._componentDecoratorsSection.setText(String.format("<form>%s</form>", text), true, false);
        this._componentDecoratorsSection.refresh();
    }

    private void updateComponentPropertiesSection(ComponentInfo compInfo) {
        ArrayList<ViewObjectPresenter.TitleValuePair> propertyLines = new ArrayList<ViewObjectPresenter.TitleValuePair>();
        String text = "";
        Set propNames = compInfo.getAttributeNames();
        for (String propName : propNames) {
            Object value;
            ComponentInfo.ComponentBeanProperty propValue = compInfo.getAttribute(propName);
            if (propValue == null || (value = propValue.getValue()) == null) continue;
            propertyLines.add(new ViewObjectPresenter.TitleValuePair(propName, value.toString()));
        }
        Collections.sort(propertyLines);
        text = ViewObjectPresenter.createLines(propertyLines);
        this._componentPropertiesSection.setText(String.format("<form>%s</form>", text), true, false);
        this._componentPropertiesSection.refresh();
    }

    protected Map<? extends Object, AbstractXMLSectionsDetailsForm.XMLTextSection> createXMLTextSections(Composite parent) {
        HashMap<String, AbstractXMLSectionsDetailsForm.XMLTextSection> sections = new HashMap<String, AbstractXMLSectionsDetailsForm.XMLTextSection>();
        this._componentSection = new AbstractXMLSectionsDetailsForm.XMLTextSection(this.getToolkit(), parent, Messages.ComponentInstanceDetailsForm_InstanceInfo);
        sections.put(COMPONENT_SECTION_KEY, this._componentSection);
        this._componentTypeSection = new AbstractXMLSectionsDetailsForm.XMLTextSection(this.getToolkit(), parent, Messages.ComponentInstanceDetailsForm_TypeInstanceInfo);
        sections.put(COMPONENT_TYPE_SECTION_KEY, this._componentTypeSection);
        this._componentInterfacesSection = new AbstractXMLSectionsDetailsForm.XMLTextSection(this.getToolkit(), parent, Messages.ComponentInstanceDetailsForm_Interfaces);
        sections.put(COMPONENT_INTERFACES_KEY, this._componentInterfacesSection);
        this._componentDecoratorsSection = new AbstractXMLSectionsDetailsForm.XMLTextSection(this.getToolkit(), parent, Messages.ComponentInstanceDetailsForm_Decorators);
        sections.put(COMPONENT_DECORATORS_KEY, this._componentDecoratorsSection);
        this._componentPropertiesSection = new AbstractXMLSectionsDetailsForm.XMLTextSection(this.getToolkit(), parent, Messages.ComponentInstanceDetailsForm_Properties);
        sections.put(COMPONENT_PROPERTIES_KEY, this._componentPropertiesSection);
        return sections;
    }

    protected Set<AbstractXMLSectionsDetailsForm.XMLTextSection> getInitiallyExpanded(Map<Object, AbstractXMLSectionsDetailsForm.XMLTextSection> sections) {
        return Collections.singleton(this._componentSection);
    }

    private static class MyLabelProvider
    extends LabelProvider {
        private MyLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ComponentDecorator) {
                if (element instanceof ConverterDecorator) {
                    ConverterDecorator converter = (ConverterDecorator)element;
                    return NLS.bind((String)Messages.ComponentInstanceDetailsForm_Converter, (Object)converter.getTypeInfo().getConverterId(), (Object)converter.getTypeInfo().getClassName());
                }
                if (element instanceof ValidatorDecorator) {
                    ValidatorDecorator validator = (ValidatorDecorator)element;
                    return NLS.bind((String)Messages.ComponentInstanceDetailsForm_Validator, (Object)validator.getTypeInfo().getValidatorId(), (Object)validator.getTypeInfo().getClassName());
                }
                if (element instanceof FacetDecorator) {
                    FacetDecorator decorator = (FacetDecorator)element;
                    return NLS.bind((String)Messages.ComponentInstanceDetailsForm_Facet, (Object)decorator.getName(), (Object)decorator.getDecorates().getId());
                }
            }
            return null;
        }
    }
}

