/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ISuspiciouslyOverloadedCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractPendingLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.CandidateCompareResult;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.util.FeatureKinds;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class SuspiciouslyOverloadedCandidate
implements IFeatureLinkingCandidate,
ISuspiciouslyOverloadedCandidate {
    private final FeatureLinkingCandidate rejectedCandidate;
    private final FeatureLinkingCandidate chosenCandidate;

    protected SuspiciouslyOverloadedCandidate(FeatureLinkingCandidate chosenCandidate, FeatureLinkingCandidate rejectedCandidate) {
        this.chosenCandidate = chosenCandidate;
        this.rejectedCandidate = rejectedCandidate;
    }

    @Override
    public FeatureLinkingCandidate getChosenCandidate() {
        return this.chosenCandidate;
    }

    @Override
    public FeatureLinkingCandidate getRejectedCandidate() {
        return this.rejectedCandidate;
    }

    @Override
    public ILinkingCandidate getPreferredCandidate(ILinkingCandidate other) {
        if (other instanceof FeatureLinkingCandidate) {
            FeatureLinkingCandidate right = (FeatureLinkingCandidate)other;
            CandidateCompareResult candidateCompareResult = this.compareTo(right);
            switch (candidateCompareResult) {
                case EQUALLY_INVALID: {
                    throw new IllegalStateException();
                }
                case AMBIGUOUS: {
                    return this.chosenCandidate.createAmbiguousLinkingCandidate(right);
                }
                case THIS: {
                    return this;
                }
            }
            return new SuspiciouslyOverloadedCandidate(right, this.rejectedCandidate);
        }
        throw new IllegalArgumentException("other was " + String.valueOf(other));
    }

    protected CandidateCompareResult compareTo(AbstractPendingLinkingCandidate<?> right) {
        CandidateCompareResult result = this.chosenCandidate.compareTo(right);
        return result;
    }

    @Override
    public void applyToComputationState() {
        this.chosenCandidate.getState().getResolvedTypes().reassignLinkingInformation((XExpression)this.chosenCandidate.getExpression(), this);
        this.chosenCandidate.applyToComputationState();
    }

    @Override
    public void applyToModel(IResolvedTypes resolvedTypes) {
        this.chosenCandidate.applyToModel(resolvedTypes);
    }

    @Override
    public boolean validate(IAcceptor<? super AbstractDiagnostic> result) {
        if (this.chosenCandidate.validate(result)) {
            StringBuilder messageBuilder = new StringBuilder("Suspiciously overloaded method.\n");
            messageBuilder.append("The ").append(this.getFeatureTypeName()).append("\n\t");
            this.appendCandidate(this.chosenCandidate, messageBuilder);
            messageBuilder.append("\noverloads the ").append(this.getFeatureTypeName()).append("\n\t");
            this.appendCandidate(this.rejectedCandidate, messageBuilder);
            messageBuilder.append(".");
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(this.chosenCandidate.getSeverity("org.eclipse.xtext.xbase.validation.IssueCodes.suspiciously_overloaded_feature"), "org.eclipse.xtext.xbase.validation.IssueCodes.suspiciously_overloaded_feature", messageBuilder.toString(), (EObject)this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
            result.accept((Object)diagnostic);
        }
        return false;
    }

    protected void appendCandidate(FeatureLinkingCandidate candidate, StringBuilder result) {
        if (!candidate.getDeclaredTypeParameters().isEmpty()) {
            result.append(candidate.getFeatureTypeParametersAsString(true)).append(' ');
        }
        JvmIdentifiableElement feature = candidate.getFeature();
        result.append(feature.getSimpleName());
        result.append(candidate.getFeatureParameterTypesAsString());
        XAbstractFeatureCall receiver = (XAbstractFeatureCall)candidate.getImplicitReceiver();
        if (receiver != null) {
            JvmIdentifiableElement element = receiver.getFeature();
            String declarator = this.getDeclaratorSimpleName(feature);
            if (declarator != null) {
                result.append(" in ");
                if (!(element instanceof JvmType) && candidate.isExtension()) {
                    result.append(FeatureKinds.getTypeName(element));
                    result.append(" extension ");
                }
                result.append(declarator);
            }
            if (element instanceof JvmType) {
                result.append(" on 'this'");
            } else {
                String simpleName = element.getSimpleName();
                if (simpleName.charAt(0) != '_') {
                    result.append(" on ").append(FeatureKinds.getTypeName(element)).append(" '").append(simpleName).append("'");
                }
            }
        } else {
            String declarator = this.getDeclaratorSimpleName(feature);
            if (declarator != null) {
                result.append(" in ");
                result.append(declarator);
            }
        }
    }

    protected String getFeatureTypeName() {
        return this.chosenCandidate.getFeatureTypeName();
    }

    protected String getDeclaratorSimpleName(JvmIdentifiableElement element) {
        if (element instanceof JvmConstructor) {
            return null;
        }
        if (element instanceof JvmMember) {
            return ((JvmMember)element).getDeclaringType().getSimpleName();
        }
        return null;
    }

    @Override
    public JvmIdentifiableElement getFeature() {
        return this.chosenCandidate.getFeature();
    }

    @Override
    public XExpression getExpression() {
        return this.chosenCandidate.getExpression();
    }

    @Override
    public List<LightweightTypeReference> getTypeArguments() {
        return this.chosenCandidate.getTypeArguments();
    }

    @Override
    public XAbstractFeatureCall getFeatureCall() {
        return this.chosenCandidate.getFeatureCall();
    }

    @Override
    public boolean isStatic() {
        return this.chosenCandidate.isStatic();
    }

    @Override
    public boolean isExtension() {
        return this.chosenCandidate.isExtension();
    }

    @Override
    public boolean isTypeLiteral() {
        return this.chosenCandidate.isTypeLiteral();
    }
}

