/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.config;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.tea.core.TaskingInjectionHelper;
import org.eclipse.tea.core.internal.TaskingConfigurationStore;
import org.eclipse.tea.core.services.TaskingConfigurationExtension;
import org.eclipse.tea.core.ui.config.TaskingEclipsePreferenceStore;
import org.osgi.service.component.annotations.Component;

@TaskingConfigurationExtension.TaskingConfig(description="TEA Build Directories")
@Component
public class BuildDirectories
implements TaskingConfigurationExtension {
    @TaskingConfigurationExtension.TaskingConfigProperty(description="Build Artifacts")
    public String buildDirOutput = "00_BUILD_OUTPUT";
    @TaskingConfigurationExtension.TaskingConfigProperty(description="Update Sites")
    public String buildDirSite = "01_BUILD_SITE";
    @TaskingConfigurationExtension.TaskingConfigProperty(description="Product Binaries")
    public String buildDirProduct = "02_BUILD_PRODUCT";
    @TaskingConfigurationExtension.TaskingConfigProperty(description="JUnit Results and Temporary Files")
    public String buildDirJunit = "03_JUNIT_RESULTS";
    @TaskingConfigurationExtension.TaskingConfigProperty(description="Runtime Directories for launches")
    public String buildDirRuntime = "04_RUNTIME";
    @TaskingConfigurationExtension.TaskingConfigProperty(description="Local Maven repository")
    public String buildDirMaven = "08_MAVEN";
    @TaskingConfigurationExtension.TaskingConfigProperty(description="General Purpose Cache directories")
    public String buildDirCache = "09_CACHE";

    public File getOutputDirectory() {
        return this.getAndCreateWorkspaceDir(this.buildDirOutput);
    }

    public File getLogDirectory() {
        return this.getAndCreateWorkspaceDir(this.buildDirOutput + "/log");
    }

    public File getSiteDirectory() {
        return this.getAndCreateWorkspaceDir(this.buildDirSite);
    }

    public File getRuntimeDirectory() {
        return this.getAndCreateWorkspaceDir(this.buildDirRuntime);
    }

    public File getJunitDirectory() {
        return this.getAndCreateWorkspaceDir(this.buildDirJunit);
    }

    public File getWorkspaceDirectory() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
    }

    private File getAndCreateWorkspaceDir(String what) {
        File r = new File(this.getWorkspaceDirectory(), what);
        r.mkdirs();
        return r;
    }

    public File getProductDirectory() {
        return this.getAndCreateWorkspaceDir(this.buildDirProduct);
    }

    public File getMavenDirectory() {
        return this.getAndCreateWorkspaceDir(this.buildDirMaven);
    }

    public File getNewCacheDirectory(String cacheName) {
        return new File(this.getBaseCacheDirectory(), cacheName + "-" + String.valueOf((Object)System.currentTimeMillis()));
    }

    public File getBaseCacheDirectory() {
        return this.getAndCreateWorkspaceDir(this.buildDirCache);
    }

    public static BuildDirectories get() {
        IEclipseContext ctx = TaskingInjectionHelper.createConfiguredContext((TaskingConfigurationStore)new TaskingEclipsePreferenceStore());
        try {
            BuildDirectories buildDirectories = (BuildDirectories)ctx.get(BuildDirectories.class);
            return buildDirectories;
        }
        finally {
            ctx.dispose();
        }
    }
}

