/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.common;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.editor.properties.ViewpointPropertySheetPage;
import org.eclipse.sirius.editor.properties.sections.common.AbstractViewpointPropertySection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractComboPropertySection
extends AbstractViewpointPropertySection {
    protected CCombo combo;
    protected CLabel nameLabel;
    protected Composite composite;
    Boolean keySelection = false;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        if (aTabbedPropertySheetPage instanceof ViewpointPropertySheetPage) {
            super.createControls(parent, (ViewpointPropertySheetPage)aTabbedPropertySheetPage);
        } else {
            super.createControls(parent, aTabbedPropertySheetPage);
        }
        super.createControls(parent, aTabbedPropertySheetPage);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.combo = this.getWidgetFactory().createCCombo(this.composite);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 232);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.combo.setLayoutData((Object)data);
        this.nameLabel = this.getWidgetFactory().createCLabel(this.composite, this.getLabelText());
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.combo, -25);
        data.top = new FormAttachment((Control)this.combo, 0, 0x1000000);
        this.nameLabel.setLayoutData((Object)data);
        this.combo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                AbstractComboPropertySection.this.keySelection = true;
                if (e.keyCode == 13) {
                    AbstractComboPropertySection.this.handleComboModified();
                    AbstractComboPropertySection.this.keySelection = false;
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!AbstractComboPropertySection.this.keySelection.booleanValue()) {
                    AbstractComboPropertySection.this.handleComboModified();
                }
            }
        });
        this.combo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                AbstractComboPropertySection.this.keySelection = false;
                AbstractComboPropertySection.this.handleComboModified();
            }
        });
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.sirius." + this.eObject.eClass().getName());
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.nameLabel.setText(this.getLabelText());
    }

    protected void handleComboModified() {
        int index = this.combo.getSelectionIndex();
        boolean equals = this.isEqual(index);
        if (!equals) {
            EditingDomain editingDomain = ((IEditingDomainProvider)this.getPart()).getEditingDomain();
            Object value = this.getFeatureValue(index);
            if (this.eObjectList.size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)this.getFeature(), (Object)value));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), (Object)value));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void refresh() {
        this.combo.setItems(this.getComboValues());
        this.combo.setText(this.getFeatureAsText());
    }

    protected String[] getComboValues() {
        List values = this.getChoiceOfValues();
        String[] array = new String[values.size()];
        int i = 0;
        while (i < values.size()) {
            array[i] = values.get(i) != null ? (values.get(i) instanceof String ? (String)values.get(i) : this.getPropertyLabel(values.get(i))) : new String();
            if (array[i] == null) {
                array[i] = new String();
            }
            ++i;
        }
        return array;
    }

    protected abstract boolean isEqual(int var1);

    @Override
    protected abstract EStructuralFeature getFeature();

    protected abstract List getChoiceOfValues();

    protected String getDefaultFeatureAsText() {
        String value = new String();
        if (this.eObject.eGet(this.getFeature()) != null) {
            value = this.eObject.eGet(this.getFeature()).toString();
        }
        return value;
    }

    protected String getFeatureAsText() {
        EStructuralFeature eFeature = this.getFeature();
        String label = this.getPropertyLabel(this.eObject.eGet(eFeature));
        return label != null ? label : this.getDefaultFeatureAsText();
    }

    protected String getPropertyLabel(Object object) {
        EStructuralFeature eFeature = this.getFeature();
        IItemPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(eFeature);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getLabelProvider((Object)this.eObject).getText(object);
        }
        return null;
    }

    protected abstract Object getFeatureValue(int var1);

    protected abstract String getDefaultLabelText();

    protected String getLabelText() {
        EStructuralFeature eFeature;
        IItemPropertyDescriptor propertyDescriptor;
        if (this.eObject != null && (propertyDescriptor = this.getPropertyDescriptor(eFeature = this.getFeature())) != null) {
            return propertyDescriptor.getDisplayName((Object)this.eObject);
        }
        return this.getDefaultLabelText();
    }

    @Override
    protected void makeReadonly() {
        this.combo.setEnabled(false);
    }

    @Override
    protected void makeWrittable() {
        this.combo.setEnabled(true);
    }
}

