/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.ui.business.internal.view.ShowingViewUtil;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.CommonEditPartOperation;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.BorderedNodeLayoutEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IStyleConfigurationRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.ViewNodeFigure;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.AirDefaultSizeNodeFigure;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusWrapLabel;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.util.AnchorProvider;
import org.eclipse.sirius.viewpoint.DStylizable;

public abstract class AbstractDiagramBorderNodeInternalEditPart
extends AbstractDiagramBorderNodeEditPart {
    protected DefaultSizeNodeFigure nodePlate = null;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public AbstractDiagramBorderNodeInternalEditPart(View view) {
        super(view);
    }

    public IFigure getNodePlate() {
        return this.nodePlate;
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("PrimaryDrag Policy", this.getPrimaryDragEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DragDropEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new BorderedNodeLayoutEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new ViewNodeFigure((View)this.getModel());
        return this.primaryShape;
    }

    public ViewNodeFigure getPrimaryShape() {
        return (ViewNodeFigure)this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        AirDefaultSizeNodeFigure result = new AirDefaultSizeNodeFigure(10, 10, null);
        EObject eObj = this.resolveSemanticElement();
        if (eObj instanceof DStylizable && eObj instanceof DDiagramElement) {
            DStylizable viewNode = (DStylizable)eObj;
            StyleConfiguration styleConfiguration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(((DDiagramElement)eObj).getDiagramElementMapping(), viewNode.getStyle());
            AnchorProvider anchorProvider = styleConfiguration.getAnchorProvider();
            result = new AirDefaultSizeNodeFigure(this.getMapMode().DPtoLP(5), this.getMapMode().DPtoLP(5), anchorProvider){

                public void paint(Graphics graphics) {
                    ShowingViewUtil.initGraphicsForVisibleAndInvisibleElements((IFigure)this, graphics, (View)AbstractDiagramBorderNodeInternalEditPart.this.getModel());
                    try {
                        CommonEditPartOperation.setGraphicsTraceabilityId(graphics, () -> AbstractDiagramBorderNodeInternalEditPart.this.resolveTargetSemanticElement());
                        super.paint(graphics);
                        CommonEditPartOperation.setGraphicsTraceabilityId(graphics, null);
                        graphics.restoreState();
                    }
                    finally {
                        graphics.popState();
                    }
                }
            };
            this.nodePlate = result;
        }
        return result;
    }

    @Override
    public void activate() {
        if (this.nodePlate instanceof AirDefaultSizeNodeFigure) {
            ((AirDefaultSizeNodeFigure)this.nodePlate).setZoomManager(this.getZoomManager());
        }
        super.activate();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.nodePlate instanceof AirDefaultSizeNodeFigure) {
            ((AirDefaultSizeNodeFigure)this.nodePlate).setZoomManager(null);
        }
    }

    protected NodeFigure createMainFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    @Override
    public SiriusWrapLabel getNodeLabel() {
        return this.getPrimaryShape().getNodeLabel();
    }

    @Override
    public IFigure getPrimaryFigure() {
        return this.getPrimaryShape();
    }

    @Override
    public Class<?> getMetamodelType() {
        return DNode.class;
    }
}

