/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.application;

import javax.servlet.ServletContext;
import org.eclipse.rwt.application.ApplicationConfiguration;
import org.eclipse.rwt.internal.application.ApplicationContext;
import org.eclipse.rwt.internal.application.ApplicationImpl;
import org.eclipse.rwt.internal.engine.RWTConfiguration;
import org.eclipse.rwt.internal.engine.RWTConfigurationImpl;
import org.eclipse.rwt.internal.service.ApplicationStoreImpl;
import org.eclipse.rwt.internal.service.ServiceManager;
import org.eclipse.rwt.internal.textsize.MeasurementListener;
import org.eclipse.rwt.internal.uicallback.UICallBackServiceHandler;
import org.eclipse.rwt.service.IApplicationStore;
import org.eclipse.rwt.service.RWTFileSettingStoreFactory;

class ApplicationContextConfigurator {
    private final ApplicationConfiguration configuration;
    private final ServletContext servletContext;

    ApplicationContextConfigurator(ApplicationConfiguration configuration, ServletContext servletContext) {
        this.configuration = configuration;
        this.servletContext = servletContext;
    }

    void configure(ApplicationContext applicationContext) {
        this.configureCustomSettings(applicationContext);
        this.configureInternalSettings(applicationContext);
    }

    void reset(ApplicationContext applicationContext) {
        this.resetSubSystems(applicationContext);
        this.resetApplicationStore(applicationContext);
    }

    private void configureCustomSettings(ApplicationContext applicationContext) {
        this.configuration.configure(this.createContext(applicationContext));
    }

    private void configureInternalSettings(ApplicationContext applicationContext) {
        this.setContextDirectory(applicationContext);
        this.addInternalPhaseListeners(applicationContext);
        this.addInternalServiceHandlers(applicationContext);
        this.setInternalSettingStoreFactory(applicationContext);
    }

    private void setContextDirectory(ApplicationContext applicationContext) {
        RWTConfiguration configurationInstance = applicationContext.getConfiguration();
        RWTConfigurationImpl configuration = (RWTConfigurationImpl)configurationInstance;
        String location = (String)this.servletContext.getAttribute("resource_root_location");
        if (location != null) {
            configuration.configure(location);
        } else {
            configuration.configure(this.servletContext.getRealPath("/"));
        }
    }

    private void resetApplicationStore(ApplicationContext applicationContext) {
        IApplicationStore storeInstance = applicationContext.getApplicationStore();
        ApplicationStoreImpl applicationStore = (ApplicationStoreImpl)storeInstance;
        applicationStore.reset();
    }

    private void resetSubSystems(ApplicationContext applicationContext) {
        applicationContext.getAdapterManager().deregisterAdapters();
        applicationContext.getBrandingManager().deregisterAll();
        applicationContext.getEntryPointManager().deregisterAll();
        applicationContext.getPhaseListenerRegistry().removeAll();
        applicationContext.getResourceRegistry().clear();
        applicationContext.getSettingStoreManager().deregisterFactory();
        this.resetConfiguration(applicationContext);
    }

    private void resetConfiguration(ApplicationContext applicationContext) {
        RWTConfiguration configurationInstance = applicationContext.getConfiguration();
        RWTConfigurationImpl configuration = (RWTConfigurationImpl)configurationInstance;
        configuration.reset();
    }

    private void addInternalPhaseListeners(ApplicationContext applicationContext) {
        applicationContext.getPhaseListenerRegistry().add(new MeasurementListener());
    }

    private void addInternalServiceHandlers(ApplicationContext applicationContext) {
        ServiceManager serviceManager = applicationContext.getServiceManager();
        String uiCallBackId = UICallBackServiceHandler.HANDLER_ID;
        serviceManager.registerServiceHandler(uiCallBackId, new UICallBackServiceHandler());
    }

    private void setInternalSettingStoreFactory(ApplicationContext applicationContext) {
        if (!applicationContext.getSettingStoreManager().hasFactory()) {
            applicationContext.getSettingStoreManager().register(new RWTFileSettingStoreFactory());
        }
    }

    private ApplicationImpl createContext(ApplicationContext applicationContext) {
        return new ApplicationImpl(applicationContext, this.configuration);
    }
}

