/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.jslp;

import ch.ethz.iks.slp.ServiceURL;
import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;

public class ServiceURLAdapter {
    private URI uri;
    private IServiceTypeID serviceID;

    public ServiceURLAdapter(ServiceURL aServiceURL) {
        this(aServiceURL, new String[0]);
    }

    public ServiceURLAdapter(ServiceURL aServiceURL, String[] scopes) {
        Assert.isNotNull((Object)aServiceURL);
        Assert.isNotNull((Object)scopes);
        this.setIServiceTypeID(aServiceURL, scopes);
        this.setURI(aServiceURL);
    }

    private void setURI(ServiceURL aServiceURL) {
        StringBuffer buf = new StringBuffer();
        String protocol = aServiceURL.getProtocol();
        if (protocol == null) {
            protocol = "unknown";
        }
        buf.append(protocol);
        buf.append("://");
        String userInfo = aServiceURL.getUserInfo();
        if (!"".equals(userInfo)) {
            buf.append(userInfo);
            buf.append('@');
        }
        buf.append(aServiceURL.getHost());
        buf.append(':');
        buf.append(aServiceURL.getPort());
        buf.append(aServiceURL.getURLPath());
        this.uri = URI.create(buf.toString());
    }

    private void setIServiceTypeID(ServiceURL aServiceURL, String[] scopes) {
        Namespace namespace = IDFactory.getDefault().getNamespaceByName("ecf.namespace.slp");
        this.serviceID = (IServiceTypeID)namespace.createInstance(new Object[]{aServiceURL, scopes});
    }

    public URI getURI() {
        return this.uri;
    }

    public IServiceTypeID getIServiceTypeID() {
        return this.serviceID;
    }
}

