/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.docshare.menu;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.docshare.DocShare;
import org.eclipse.ecf.internal.docshare.Activator;
import org.eclipse.ecf.internal.docshare.Messages;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.ui.menu.AbstractRosterMenuHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class DocShareRosterMenuHandler
extends AbstractRosterMenuHandler {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DocShareRosterMenuHandler(IRosterEntry entry) {
        super(entry);
    }

    protected ITextEditor getTextEditor() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow ww = workbench.getActiveWorkbenchWindow();
        if (ww == null) {
            return null;
        }
        IWorkbenchPage wp = ww.getActivePage();
        if (wp == null) {
            return null;
        }
        IEditorPart ep = wp.getActiveEditor();
        if (ep instanceof ITextEditor) {
            return (ITextEditor)ep;
        }
        if (ep != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ITextEditor)ep.getAdapter((Class)clazz);
        }
        return null;
    }

    private String getInputName(IEditorPart editorPart) {
        IEditorInput input = editorPart.getEditorInput();
        if (input != null) {
            return input.getName();
        }
        return null;
    }

    private void showErrorMessage(String errorMessage) {
        ErrorDialog.openError(null, (String)Messages.DocShareRosterMenuHandler_DOCSHARE_START_ERROR_TITLE, (String)errorMessage, (IStatus)new Status(4, "org.eclipse.ecf.internal.provisional.docshare", errorMessage, null));
    }

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        IRosterEntry rosterEntry = this.getRosterEntry();
        if (rosterEntry != null) {
            String inputName;
            ITextEditor textEditor;
            DocShare sender;
            IContainer container;
            IRoster roster = rosterEntry.getRoster();
            IPresenceContainerAdapter iPresenceContainerAdapter = roster.getPresenceContainerAdapter();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ecf.core.IContainer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((container = (IContainer)iPresenceContainerAdapter.getAdapter((Class)clazz)).getConnectedID() == null) {
                this.showErrorMessage(Messages.DocShareRosterMenuHandler_ERROR_NOT_CONNECTED);
            }
            if ((sender = Activator.getDefault().getDocShare(container.getID())) == null) {
                this.showErrorMessage(Messages.DocShareRosterMenuHandler_ERROR_NO_SENDER);
            }
            if (sender.isSharing()) {
                this.showErrorMessage(Messages.DocShareRosterMenuHandler_ERROR_EDITOR_ALREADY_SHARING);
            }
            if ((textEditor = this.getTextEditor()) == null) {
                this.showErrorMessage(Messages.DocShareRosterMenuHandler_EXCEPTION_EDITOR_NOT_TEXT);
            }
            if ((inputName = this.getInputName((IEditorPart)textEditor)) == null) {
                this.showErrorMessage(Messages.DocShareRosterMenuHandler_NO_FILENAME_WITH_CONTENT);
            }
            IUser user = roster.getUser();
            sender.startShare(user.getID(), user.getName(), rosterEntry.getUser().getID(), inputName, textEditor);
        }
        return null;
    }
}

