/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.lucene;

import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.eclipse.dltk.internal.core.index.lucene.IndexContainer;
import org.eclipse.dltk.internal.core.index.lucene.Logger;
import org.eclipse.dltk.internal.core.index.lucene.Utils;
import org.eclipse.dltk.internal.core.search.ProjectIndexerManager;

public final class IndexRecovery {
    private static final String RECOVERY_REASON = "Index writer could not be created, index data might be corrupted.";
    private static final String RECOVERY_STARTED = "Recovering index storage: {0}";
    private static final String RECOVERY_FAILED = "Failed to recover index storage: {0}";

    private IndexRecovery() {
    }

    static void tryRecover(IndexContainer indexContainer, Path indexPath, IOException exception) {
        Logger.logException(RECOVERY_REASON, exception);
        Logger.log(1, MessageFormat.format(RECOVERY_STARTED, indexPath.toString()));
        try {
            Utils.delete(indexPath);
            indexContainer.getTimestampsWriter().deleteDocuments(new Query[]{new MatchAllDocsQuery()});
        }
        catch (IOException e) {
            Logger.logException(MessageFormat.format(RECOVERY_FAILED, indexPath.toString()), e);
            return;
        }
        ProjectIndexerManager.startIndexing();
    }
}

