/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiDescription;
import org.eclipse.pde.api.tools.internal.ApiDescriptionProcessor;
import org.eclipse.pde.api.tools.internal.BundleVersionRange;
import org.eclipse.pde.api.tools.internal.CompositeApiDescription;
import org.eclipse.pde.api.tools.internal.FilterStore;
import org.eclipse.pde.api.tools.internal.RequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.model.ApiBaseline;
import org.eclipse.pde.api.tools.internal.model.ArchiveApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.Component;
import org.eclipse.pde.api.tools.internal.model.DirectoryApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.Messages;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.IRequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.provisional.ProfileModifiers;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.util.SourceDefaultHandler;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.internal.core.TargetWeaver;
import org.eclipse.pde.internal.core.util.ManifestUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BundleComponent
extends Component {
    static final String TMP_API_FILE_PREFIX = "api";
    private volatile Map<String, String> fManifest;
    private static final String[] MANIFEST_HEADERS = new String[]{"Eclipse-SourceBundle", "Bundle-ClassPath", "Bundle-Name", "Bundle-Version"};
    private volatile boolean fHasApiDescription;
    private final String fLocation;
    private volatile BundleDescription fBundleDescription;
    private String fSymbolicName;
    private volatile Version fVersion;
    private volatile String[] lowestEEs;
    private final boolean fWorkspaceBinary;
    private final long fBundleId;
    private volatile RuntimeException disposeSource;
    private static final List<String> FIXED_API_DESCRIPTIONS = Arrays.asList("org.eclipse.swt.win32.win32.x86-64-3.125.0.v20240227-1638", "org.eclipse.swt.gtk.linux.x86-64-3.125.0.v20240227-1638", "org.eclipse.swt.gtk.linux.ppc64le-3.125.0.v20240227-1638", "org.eclipse.swt.gtk.linux.aarch64-3.125.0.v20240227-1638", "org.eclipse.swt.cocoa.macosx.aarch64-3.125.0.v20240227-1638", "org.eclipse.swt.cocoa.macosx.x86-64-3.125.0.v20240227-1638");

    public BundleComponent(IApiBaseline baseline, String location, long bundleid) throws CoreException {
        super(baseline);
        this.fLocation = location;
        this.fBundleId = bundleid;
        this.fWorkspaceBinary = this.isBinary() && "workspace".equals(baseline.getName()) && !new File(location).isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        try {
            super.dispose();
        }
        catch (Throwable throwable) {
            BundleComponent bundleComponent = this;
            synchronized (bundleComponent) {
                this.fManifest = null;
                this.fBundleDescription = null;
                this.disposeSource = new RuntimeException("Component was disposed here");
            }
            throw throwable;
        }
        BundleComponent bundleComponent = this;
        synchronized (bundleComponent) {
            this.fManifest = null;
            this.fBundleDescription = null;
            this.disposeSource = new RuntimeException("Component was disposed here");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getManifest() throws CoreException {
        if (this.fManifest != null) {
            return this.fManifest;
        }
        Map<String, String> manifest = BundleComponent.loadManifest(new File(this.fLocation), this.isWorkspaceBinary());
        BundleComponent bundleComponent = this;
        synchronized (bundleComponent) {
            if (this.fManifest == null) {
                this.fManifest = manifest;
            }
            return this.fManifest;
        }
    }

    private static Map<String, String> loadManifest(File bundleLocation, boolean isWorkspaceBinary) throws CoreException {
        try {
            Map manifest = ManifestUtils.loadManifest((File)bundleLocation);
            if (isWorkspaceBinary) {
                TargetWeaver.weaveManifest((Map)manifest, (File)bundleLocation);
            }
            return manifest;
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 204) {
                return null;
            }
            throw e;
        }
    }

    protected synchronized void doManifestCompaction() {
        Map<String, String> temp = this.fManifest;
        this.fManifest = new Hashtable<String, String>(MANIFEST_HEADERS.length, 1.0f);
        String[] stringArray = MANIFEST_HEADERS;
        int n = MANIFEST_HEADERS.length;
        int n2 = 0;
        while (n2 < n) {
            String header = stringArray[n2];
            String value = temp.get(header);
            if (value != null) {
                this.fManifest.put(header, value);
            }
            ++n2;
        }
    }

    public boolean isValidBundle() throws CoreException {
        Map<String, String> manifest = this.getManifest();
        return manifest != null && manifest.get("Bundle-Name") != null && manifest.get("Bundle-Version") != null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BundleComponent) {
            BundleComponent comp = (BundleComponent)obj;
            return this.getName().equals(comp.getName()) && this.getSymbolicName().equals(comp.getSymbolicName()) && this.getVersion().equals(comp.getVersion());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getSymbolicName().hashCode() + this.getVersion().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws CoreException {
        if (this.isDisposed() || this.fBundleDescription != null) {
            return;
        }
        BundleComponent bundleComponent = this;
        synchronized (bundleComponent) {
            try {
                Map<String, String> manifest = this.getManifest();
                if (manifest == null) {
                    throw new CoreException(Status.error((String)("Unable to find a manifest for the component from: " + this.fLocation), null));
                }
                BundleDescription bundleDescription = this.getBundleDescription(manifest, this.fLocation, this.fBundleId);
                this.fSymbolicName = bundleDescription.getSymbolicName();
                this.fVersion = bundleDescription.getVersion();
                this.setName(manifest.get("Bundle-Name"));
                this.fBundleDescription = bundleDescription;
            }
            catch (BundleException e) {
                throw new CoreException(Status.error((String)("Unable to create API component from specified location: " + this.fLocation), (Throwable)e));
            }
            this.doManifestCompaction();
        }
    }

    public boolean isWorkspaceBinary() {
        return this.fWorkspaceBinary;
    }

    protected State getState() {
        return ((ApiBaseline)this.getBaseline()).getState();
    }

    protected BundleDescription getBundleDescription(Map<String, String> manifest, String location, long id) throws BundleException {
        State state = this.getState();
        BundleDescription bundle = BundleComponent.lookupBundle(state, manifest);
        if (bundle != null) {
            return bundle;
        }
        StateObjectFactory factory = StateObjectFactory.defaultFactory;
        bundle = factory.createBundleDescription(state, FrameworkUtil.asDictionary(manifest), this.fLocation, id);
        state.addBundle(bundle);
        return bundle;
    }

    protected static BundleDescription lookupBundle(State state, Map<String, String> manifest) throws BundleException {
        Version version = null;
        try {
            String ver = manifest.get("Bundle-Version");
            version = ver != null ? new Version(ver) : null;
        }
        catch (NumberFormatException ver) {
            // empty catch block
        }
        ManifestElement[] name = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)manifest.get("Bundle-SymbolicName"));
        if (name.length < 1) {
            return null;
        }
        return state.getBundle(name[0].getValue(), version);
    }

    protected boolean isBinary() {
        return true;
    }

    @Override
    protected IApiDescription createApiDescription() throws CoreException {
        BundleDescription[] fragments = this.getBundleDescription().getFragments();
        if (fragments.length == 0) {
            return this.createLocalApiDescription();
        }
        ArrayList<IApiDescription> descriptions = new ArrayList<IApiDescription>(fragments.length);
        descriptions.add(this.createLocalApiDescription());
        BundleDescription[] bundleDescriptionArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription fragment = bundleDescriptionArray[n2];
            if (fragment.isResolved()) {
                IApiComponent component = this.getBaseline().getApiComponent(fragment.getSymbolicName());
                if (component != null) {
                    descriptions.add(component.getApiDescription());
                } else {
                    ApiPlugin.log(Status.warning((String)NLS.bind((String)Messages.BundleComponent_failed_to_lookup_fragment, (Object)fragment.getSymbolicName())));
                }
            }
            ++n2;
        }
        return new CompositeApiDescription(descriptions.toArray(new IApiDescription[descriptions.size()]));
    }

    protected IApiDescription createLocalApiDescription() throws CoreException {
        ApiDescription apiDesc = new ApiDescription(this.getSymbolicName());
        BundleComponent.initializeApiDescription(apiDesc, this.getBundleDescription(), this.getLocalPackageNames());
        try {
            String xml = BundleComponent.loadApiDescription(new File(this.fLocation));
            this.setHasApiDescription(xml != null);
            if (xml != null) {
                ApiDescriptionProcessor.annotateApiSettings(null, apiDesc, xml);
            }
        }
        catch (IOException e) {
            this.abort("Unable to load .api_description file ", e);
        }
        return apiDesc;
    }

    protected Set<String> getLocalPackageNames() throws CoreException {
        IApiTypeContainer[] containers;
        HashSet<String> names = new HashSet<String>();
        IApiTypeContainer[] iApiTypeContainerArray = containers = this.getApiTypeContainers();
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IApiTypeContainer container = iApiTypeContainerArray[n2];
            IApiComponent comp = (IApiComponent)container.getAncestor(1);
            if (comp != null && comp.getSymbolicName().equals(this.getSymbolicName())) {
                String[] packageNames = container.getPackageNames();
                Collections.addAll(names, packageNames);
            }
            ++n2;
        }
        return names;
    }

    public static void initializeApiDescription(IApiDescription apiDesc, BundleDescription bundle, Set<String> packages) {
        int n;
        int n2;
        BundleDescription[] bundleDescriptionArray;
        for (String name : packages) {
            apiDesc.setVisibility(Factory.packageDescriptor(name), 2);
        }
        ArrayList<ExportPackageDescription> supplied = new ArrayList<ExportPackageDescription>();
        ExportPackageDescription[] exportPackages = bundle.getExportPackages();
        BundleComponent.addSuppliedPackages(packages, supplied, exportPackages);
        HostSpecification host = bundle.getHost();
        if (host != null) {
            BundleDescription[] hosts;
            bundleDescriptionArray = hosts = host.getHosts();
            n2 = hosts.length;
            n = 0;
            while (n < n2) {
                BundleDescription bundleDescription = bundleDescriptionArray[n];
                BundleComponent.addSuppliedPackages(packages, supplied, bundleDescription.getExportPackages());
                ++n;
            }
        }
        BundleDescription[] fragments = bundle.getFragments();
        bundleDescriptionArray = fragments;
        n2 = fragments.length;
        n = 0;
        while (n < n2) {
            BundleDescription fragment = bundleDescriptionArray[n];
            if (fragment.isResolved()) {
                BundleComponent.addSuppliedPackages(packages, supplied, fragment.getExportPackages());
            }
            ++n;
        }
        BundleComponent.annotateExportedPackages(apiDesc, supplied.toArray(new ExportPackageDescription[supplied.size()]));
    }

    protected static void addSuppliedPackages(Set<String> packages, List<ExportPackageDescription> supplied, ExportPackageDescription[] exportPackages) {
        ExportPackageDescription[] exportPackageDescriptionArray = exportPackages;
        int n = exportPackages.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription pkg = exportPackageDescriptionArray[n2];
            String name = pkg.getName();
            if (name.equals(".")) {
                name = "";
            }
            if (packages.contains(name)) {
                supplied.add(pkg);
            }
            ++n2;
        }
    }

    protected static void annotateExportedPackages(IApiDescription apiDesc, ExportPackageDescription[] exportedPackages) {
        ExportPackageDescription[] exportPackageDescriptionArray = exportedPackages;
        int n = exportedPackages.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription pkg = exportPackageDescriptionArray[n2];
            boolean internal = (Boolean)pkg.getDirective("x-internal");
            String[] friends = (String[])pkg.getDirective("x-friends");
            String pkgName = pkg.getName();
            if (pkgName.equals(".")) {
                pkgName = "";
            }
            IPackageDescriptor pkgDesc = Factory.packageDescriptor(pkgName);
            if (internal) {
                apiDesc.setVisibility(pkgDesc, 2);
            }
            if (friends != null) {
                apiDesc.setVisibility(pkgDesc, 2);
                String[] stringArray = friends;
                int n3 = friends.length;
                int n4 = 0;
                while (n4 < n3) {
                    String friend = stringArray[n4];
                    apiDesc.setAccessLevel(Factory.componentDescriptor(friend), Factory.packageDescriptor(pkgName), 1);
                    ++n4;
                }
            }
            if (!internal && friends == null) {
                apiDesc.setVisibility(pkgDesc, 1);
            }
            ++n2;
        }
    }

    @Override
    protected IApiFilterStore createApiFilterStore() throws CoreException {
        return new FilterStore(this);
    }

    @Override
    protected List<IApiTypeContainer> createApiTypeContainers() throws CoreException {
        BundleDescription[] fragments;
        ArrayList<IApiTypeContainer> containers = new ArrayList<IApiTypeContainer>(5);
        ArrayList<BundleComponent> all = new ArrayList<BundleComponent>();
        all.add(this);
        BundleDescription[] bundleDescriptionArray = fragments = this.getBundleDescription().getFragments();
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent component;
            BundleDescription fragment = bundleDescriptionArray[n2];
            if (fragment.isResolved() && (component = this.getBaseline().getApiComponent(fragment.getSymbolicName())) != null) {
                component.getApiTypeContainers();
                all.add((BundleComponent)component);
            }
            ++n2;
        }
        HashSet<String> entryNames = new HashSet<String>(5);
        for (BundleComponent component : all) {
            Map<String, String> manifest = component.getManifest();
            if (manifest == null) continue;
            try {
                List<String> paths = BundleComponent.getClasspathEntries(manifest);
                for (String path : paths) {
                    if (!".".equals(path) && entryNames.contains(path)) continue;
                    IApiTypeContainer container = component.createApiTypeContainer(path);
                    if (container == null) {
                        for (BundleComponent other : all) {
                            if (other == component) continue;
                            container = other.createApiTypeContainer(path);
                        }
                    }
                    if (container == null) continue;
                    containers.add(container);
                    if (".".equals(path)) continue;
                    entryNames.add(path);
                }
            }
            catch (BundleException e) {
                this.abort("Unable to parse bundle-classpath entry of manifest for bundle at " + component.getLocation(), e);
            }
        }
        return containers;
    }

    protected boolean isApiEnabled() {
        return false;
    }

    private static List<String> getClasspathEntries(Map<String, String> manifest) throws BundleException {
        ManifestElement[] classpath = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)manifest.get("Bundle-ClassPath"));
        if (classpath == null) {
            return List.of(".");
        }
        return Arrays.stream(classpath).map(ManifestElement::getValue).toList();
    }

    protected IApiTypeContainer createApiTypeContainer(String path) throws CoreException {
        block19: {
            try {
                File bundle = new File(this.fLocation);
                if (bundle.isDirectory()) {
                    File entry = new File(bundle, path);
                    if (entry.exists()) {
                        if (entry.isFile()) {
                            return new ArchiveApiTypeContainer(this, entry.getCanonicalPath());
                        }
                        return new DirectoryApiTypeContainer(this, entry.getCanonicalPath());
                    }
                    break block19;
                }
                if (path.equals(".")) {
                    return new ArchiveApiTypeContainer(this, this.fLocation);
                }
                Throwable throwable = null;
                Object var4_7 = null;
                try (ZipFile zip = new ZipFile(this.fLocation);){
                    ZipEntry entry = zip.getEntry(path);
                    if (entry != null) {
                        if (entry.isDirectory()) {
                            Path dir = Util.createTempDirectory(TMP_API_FILE_PREFIX).toRealPath(new LinkOption[0]);
                            BundleComponent.extractDirectory(zip, entry.getName(), dir);
                            return new DirectoryApiTypeContainer(this, dir.toString());
                        }
                        if (Util.isArchive(path)) {
                            Path dir = Util.createTempDirectory(TMP_API_FILE_PREFIX).toRealPath(new LinkOption[0]);
                            Path file = BundleComponent.extractEntry(zip, entry, dir);
                            return new ArchiveApiTypeContainer(this, file.toRealPath(new LinkOption[0]).toString());
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.abort("Problem creating api type container for path " + path + " in bundle at " + this.fLocation, e);
            }
        }
        return null;
    }

    private static void extractDirectory(ZipFile zip, String pathprefix, Path parent) throws IOException {
        String prefix = pathprefix == null ? "" : pathprefix;
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(prefix)) continue;
            BundleComponent.extractEntry(zip, entry, parent);
        }
    }

    private static Path extractEntry(ZipFile zip, ZipEntry entry, Path parent) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream inputStream = zip.getInputStream(entry);){
            String name = entry.getName();
            Path file = parent.resolve(name).normalize();
            if (!file.startsWith(parent)) {
                throw new ZipException("Bad zip entry: " + name);
            }
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.copy(inputStream, file, new CopyOption[0]);
            return file;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void closingZipFileAndStream(InputStream stream, ZipFile jarFile) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            ApiPlugin.log(e);
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException e) {
            ApiPlugin.log(e);
        }
    }

    protected static String readFileContents(String xmlFileName, File bundleLocation) {
        block11: {
            String string;
            ZipFile jarFile = null;
            InputStream stream = null;
            try {
                String extension = IPath.fromOSString((String)bundleLocation.getName()).getFileExtension();
                if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                    jarFile = new ZipFile(bundleLocation, 1);
                    ZipEntry manifestEntry = jarFile.getEntry(xmlFileName);
                    if (manifestEntry != null) {
                        stream = jarFile.getInputStream(manifestEntry);
                    }
                } else {
                    File file = new File(bundleLocation, xmlFileName);
                    if (file.exists()) {
                        stream = new FileInputStream(file);
                    }
                }
                if (stream == null) {
                    BundleComponent.closingZipFileAndStream(stream, jarFile);
                    return null;
                }
                string = new String(Util.getInputStreamAsCharArray(stream, StandardCharsets.UTF_8));
                BundleComponent.closingZipFileAndStream(stream, jarFile);
            }
            catch (IOException e) {
                ApiPlugin.log(e);
                break block11;
            }
            finally {
                BundleComponent.closingZipFileAndStream(stream, jarFile);
            }
            return string;
        }
        return null;
    }

    protected static String loadApiDescription(File bundleLocation) throws IOException {
        InputStream stream;
        ZipFile jarFile;
        block9: {
            jarFile = null;
            stream = null;
            try {
                String fileName = bundleLocation.getName();
                String extension = IPath.fromOSString((String)fileName).getFileExtension();
                if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                    String bundleAndVersion = fileName.substring(0, fileName.length() - ".jar".length()).replace('_', '-');
                    if (FIXED_API_DESCRIPTIONS.contains(bundleAndVersion)) {
                        stream = BundleComponent.loadFixedBundleApiDescription(bundleAndVersion);
                    } else {
                        jarFile = new ZipFile(bundleLocation, 1);
                        ZipEntry manifestEntry = jarFile.getEntry(".api_description");
                        if (manifestEntry != null) {
                            stream = jarFile.getInputStream(manifestEntry);
                        }
                    }
                } else {
                    File file = new File(bundleLocation, ".api_description");
                    if (file.exists()) {
                        stream = new FileInputStream(file);
                    }
                }
                if (stream != null) break block9;
            }
            catch (Throwable throwable) {
                BundleComponent.closingZipFileAndStream(stream, jarFile);
                throw throwable;
            }
            BundleComponent.closingZipFileAndStream(stream, jarFile);
            return null;
        }
        char[] charArray = Util.getInputStreamAsCharArray(stream, StandardCharsets.UTF_8);
        String contents = new String(charArray);
        BundleComponent.closingZipFileAndStream(stream, jarFile);
        return contents;
    }

    private static InputStream loadFixedBundleApiDescription(String bundleAndVersion) throws IOException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.pde.api.tools");
        IPath pathInBundle = IPath.fromOSString((String)("fixed_api_descriptions/" + bundleAndVersion + ".api_description"));
        return FileLocator.openStream((Bundle)bundle, (IPath)pathInBundle, (boolean)false);
    }

    @Override
    public String[] getExecutionEnvironments() throws CoreException {
        return this.getBundleDescription().getExecutionEnvironments();
    }

    @Override
    public final String getSymbolicName() {
        try {
            this.init();
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
        return this.fSymbolicName;
    }

    @Override
    public IRequiredComponentDescription[] getRequiredComponents() throws CoreException {
        BundleSpecification[] requiredBundles = this.getBundleDescription().getRequiredBundles();
        return (IRequiredComponentDescription[])Arrays.stream(requiredBundles).map(b -> new RequiredComponentDescription(b.getName(), new BundleVersionRange(b.getVersionRange()), b.isOptional(), b.isExported())).toArray(IRequiredComponentDescription[]::new);
    }

    @Override
    public String getVersion() {
        try {
            this.init();
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
        Version version = this.fVersion;
        if (version == null) {
            return null;
        }
        return version.getMajor() + "." + version.getMinor() + "." + version.getMicro();
    }

    @Override
    public String getName() {
        try {
            this.init();
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
        return super.getName();
    }

    public BundleDescription getBundleDescription() throws CoreException {
        this.init();
        BundleDescription description = this.fBundleDescription;
        if (this.isDisposed() || description == null) {
            this.baselineDisposed(this.getBaseline());
        }
        return description;
    }

    public String toString() {
        BundleDescription description = this.fBundleDescription;
        if (description != null) {
            try {
                StringBuilder buffer = new StringBuilder();
                buffer.append(description.toString());
                buffer.append(" - ");
                buffer.append("[fragment: ").append(this.isFragment()).append("] ");
                buffer.append("[host: ").append(description.getFragments().length > 0).append("] ");
                buffer.append("[system bundle: ").append(this.isSystemComponent()).append("] ");
                buffer.append("[source bundle: ").append(this.isSourceComponent()).append("] ");
                buffer.append("[dev bundle: ").append(this.fWorkspaceBinary).append("]");
                return buffer.toString();
            }
            catch (CoreException ce) {
                return super.toString();
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (this.isDisposed()) {
            buffer.append("Disposed ");
        } else {
            buffer.append("Un-initialized ");
        }
        buffer.append("Bundle Component");
        buffer.append("[location: ").append(this.fLocation).append("]");
        buffer.append("[dev bundle: ").append(this.fWorkspaceBinary).append("]");
        return buffer.toString();
    }

    @Override
    public String getLocation() {
        return this.fLocation;
    }

    @Override
    public boolean isSystemComponent() {
        return false;
    }

    @Override
    public boolean isSourceComponent() throws CoreException {
        Map<String, String> manifest = this.getManifest();
        if (manifest == null) {
            this.baselineDisposed(this.getBaseline());
        }
        return BundleComponent.isSourceComponent(manifest, new File(this.getLocation()));
    }

    private static boolean isSourceComponent(Map<String, String> manifest, File location) {
        ManifestElement[] sourceBundle = null;
        try {
            sourceBundle = ManifestElement.parseHeader((String)"Eclipse-SourceBundle", (String)manifest.get("Eclipse-SourceBundle"));
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
        if (sourceBundle != null) {
            return true;
        }
        String pluginXMLContents = BundleComponent.readFileContents("plugin.xml", location);
        if (pluginXMLContents != null && BundleComponent.containsSourceExtensionPoint(pluginXMLContents)) {
            return true;
        }
        pluginXMLContents = BundleComponent.readFileContents("fragment.xml", location);
        return pluginXMLContents != null && BundleComponent.containsSourceExtensionPoint(pluginXMLContents);
    }

    private static boolean containsSourceExtensionPoint(String pluginXMLContents) {
        try {
            SAXParser saxParser = XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE();
            SourceDefaultHandler defaultHandler = new SourceDefaultHandler();
            saxParser.parse(new InputSource(new StringReader(pluginXMLContents)), (DefaultHandler)defaultHandler);
            return defaultHandler.isSource();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return false;
        }
    }

    @Override
    public boolean isFragment() throws CoreException {
        return this.getBundleDescription().getHost() != null;
    }

    @Override
    public IApiComponent getHost() throws CoreException {
        HostSpecification host = this.getBundleDescription().getHost();
        if (host != null) {
            return this.getBaseline().getApiComponent(host.getName());
        }
        return null;
    }

    @Override
    public boolean hasFragments() throws CoreException {
        return this.getBundleDescription().getFragments().length != 0;
    }

    protected void setHasApiDescription(boolean hasApiDescription) {
        this.fHasApiDescription = hasApiDescription;
    }

    @Override
    public boolean hasApiDescription() {
        try {
            this.getApiDescription();
        }
        catch (CoreException e) {
            ApiPlugin.log("Failed to create API description for " + this.getName(), e);
        }
        return this.fHasApiDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getLowestEEs() throws CoreException {
        if (this.lowestEEs != null) {
            return this.lowestEEs;
        }
        String[] executionEnvironments = this.getExecutionEnvironments();
        String[] ees = BundleComponent.computeLowestEEs(executionEnvironments);
        BundleComponent bundleComponent = this;
        synchronized (bundleComponent) {
            this.lowestEEs = ees;
            return this.lowestEEs;
        }
    }

    private static String[] computeLowestEEs(String[] executionEnvironments) {
        String[] temp = null;
        int length = executionEnvironments.length;
        switch (length) {
            case 0: {
                return null;
            }
            case 1: {
                temp = new String[]{executionEnvironments[0]};
                break;
            }
            default: {
                int tempLength;
                int values = 0;
                int i = 0;
                while (i < length) {
                    values |= ProfileModifiers.getValue(executionEnvironments[i]);
                    ++i;
                }
                if (ProfileModifiers.isJRE(values)) {
                    temp = ProfileModifiers.isJRE_1_1(values) ? new String[]{"JRE-1.1"} : (ProfileModifiers.isJ2SE_1_2(values) ? new String[]{"J2SE-1.2"} : (ProfileModifiers.isJ2SE_1_3(values) ? new String[]{"J2SE-1.3"} : (ProfileModifiers.isJ2SE_1_4(values) ? new String[]{"J2SE-1.4"} : (ProfileModifiers.isJ2SE_1_5(values) ? new String[]{"J2SE-1.5"} : (ProfileModifiers.isJAVASE_1_6(values) ? new String[]{"JavaSE-1.6"} : (ProfileModifiers.isJAVASE_1_7(values) ? new String[]{"JavaSE-1.7"} : (ProfileModifiers.isJAVASE_1_8(values) ? new String[]{"JavaSE-1.8"} : new String[]{"JavaSE-9"})))))));
                }
                if (ProfileModifiers.isCDC_Foundation(values)) {
                    temp = ProfileModifiers.isCDC_1_0_FOUNDATION_1_0(values) ? (temp != null ? new String[]{temp[0], "CDC-1.0/Foundation-1.0"} : new String[]{"CDC-1.0/Foundation-1.0"}) : (temp != null ? new String[]{temp[0], "CDC-1.1/Foundation-1.1"} : new String[]{"CDC-1.1/Foundation-1.1"});
                }
                if (!ProfileModifiers.isOSGi(values)) break;
                if (ProfileModifiers.isOSGI_MINIMUM_1_0(values)) {
                    if (temp != null) {
                        tempLength = temp.length;
                        String[] stringArray = temp;
                        temp = new String[tempLength + 1];
                        System.arraycopy(stringArray, 0, temp, 0, tempLength);
                        temp[tempLength] = "OSGi/Minimum-1.0";
                        break;
                    }
                    temp = new String[]{"OSGi/Minimum-1.0"};
                    break;
                }
                if (ProfileModifiers.isOSGI_MINIMUM_1_1(values)) {
                    if (temp != null) {
                        tempLength = temp.length;
                        String[] stringArray = temp;
                        temp = new String[tempLength + 1];
                        System.arraycopy(stringArray, 0, temp, 0, tempLength);
                        temp[tempLength] = "OSGi/Minimum-1.1";
                        break;
                    }
                    temp = new String[]{"OSGi/Minimum-1.1"};
                    break;
                }
                if (temp != null) {
                    tempLength = temp.length;
                    String[] stringArray = temp;
                    temp = new String[tempLength + 1];
                    System.arraycopy(stringArray, 0, temp, 0, tempLength);
                    temp[tempLength] = "OSGi/Minimum-1.2";
                    break;
                }
                temp = new String[]{"OSGi/Minimum-1.2"};
            }
        }
        return temp;
    }

    @Override
    public ResolverError[] getErrors() throws CoreException {
        ApiBaseline baseline = (ApiBaseline)this.getBaseline();
        if (baseline != null) {
            BundleDescription bundleDescription = this.getBundleDescription();
            ResolverError[] resolverErrors = baseline.getState().getResolverErrors(bundleDescription);
            if (resolverErrors.length == 0) {
                return null;
            }
            return resolverErrors;
        }
        return null;
    }

    protected void baselineDisposed(IApiBaseline baseline) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", 123, NLS.bind((String)Messages.BundleApiComponent_baseline_disposed, (Object)this.getName(), (Object)baseline.getName()), (Throwable)this.disposeSource));
    }
}

