/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.registry.view;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiLookup;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryChangeListener;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.runtime.registry.IRegistryView;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public abstract class AbstractRegistryView
implements IRegistryView {
    private static final String LISTENER_EXCEPTION_REMOVE = "Exception occurred while notifying view listener %s about entry removal";
    private static final String LISTENER_EXCEPTION_ADD = "Exception occurred while notifying view listener %s about entry addition";
    protected final IQuerySpecificationRegistry registry;
    protected final IMultiLookup<String, IQuerySpecificationRegistryEntry> fqnToEntryMap;
    protected final Set<IQuerySpecificationRegistryChangeListener> listeners;
    protected final boolean allowDuplicateFQNs;

    protected abstract boolean isEntryRelevant(IQuerySpecificationRegistryEntry var1);

    public AbstractRegistryView(IQuerySpecificationRegistry registry, boolean allowDuplicateFQNs) {
        this.registry = registry;
        this.allowDuplicateFQNs = allowDuplicateFQNs;
        this.fqnToEntryMap = CollectionsFactory.createMultiLookup(Object.class, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.SETS, Object.class);
        this.listeners = new HashSet<IQuerySpecificationRegistryChangeListener>();
    }

    @Override
    public IQuerySpecificationRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public Iterable<IQuerySpecificationRegistryEntry> getEntries() {
        return this.fqnToEntryMap.distinctValuesStream().collect(Collectors.toSet());
    }

    @Override
    public Set<String> getQuerySpecificationFQNs() {
        return this.fqnToEntryMap.distinctKeysStream().collect(Collectors.toSet());
    }

    @Override
    public boolean hasQuerySpecificationFQN(String fullyQualifiedName) {
        Preconditions.checkArgument((fullyQualifiedName != null ? 1 : 0) != 0, (String)"FQN must not be null!");
        return this.fqnToEntryMap.lookupExists((Object)fullyQualifiedName);
    }

    @Override
    public Set<IQuerySpecificationRegistryEntry> getEntries(String fullyQualifiedName) {
        Preconditions.checkArgument((fullyQualifiedName != null ? 1 : 0) != 0, (String)"FQN must not be null!");
        IMemoryView entries = this.fqnToEntryMap.lookupOrEmpty((Object)fullyQualifiedName);
        return Collections.unmodifiableSet(entries.distinctValues());
    }

    @Override
    public void addViewListener(IQuerySpecificationRegistryChangeListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (String)"Null listener not supported");
        this.listeners.add(listener);
    }

    @Override
    public void removeViewListener(IQuerySpecificationRegistryChangeListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (String)"Null listener not supported");
        this.listeners.remove(listener);
    }

    @Override
    public void entryAdded(IQuerySpecificationRegistryEntry entry) {
        if (this.isEntryRelevant(entry)) {
            String fullyQualifiedName = entry.getFullyQualifiedName();
            IMemoryView duplicates = this.fqnToEntryMap.lookup((Object)fullyQualifiedName);
            if (!this.allowDuplicateFQNs && duplicates != null) {
                HashSet removed = new HashSet(duplicates.distinctValues());
                for (IQuerySpecificationRegistryEntry e : removed) {
                    this.fqnToEntryMap.removePair((Object)fullyQualifiedName, (Object)e);
                    this.notifyListeners(e, false);
                }
            }
            this.fqnToEntryMap.addPair((Object)fullyQualifiedName, (Object)entry);
            this.notifyListeners(entry, true);
        }
    }

    @Override
    public void entryRemoved(IQuerySpecificationRegistryEntry entry) {
        if (this.isEntryRelevant(entry)) {
            String fullyQualifiedName = entry.getFullyQualifiedName();
            this.fqnToEntryMap.removePair((Object)fullyQualifiedName, (Object)entry);
            this.notifyListeners(entry, false);
        }
    }

    private void notifyListeners(IQuerySpecificationRegistryEntry entry, boolean addition) {
        for (IQuerySpecificationRegistryChangeListener listener : this.listeners) {
            try {
                if (addition) {
                    listener.entryAdded(entry);
                    continue;
                }
                listener.entryRemoved(entry);
            }
            catch (Exception ex) {
                Logger logger = ViatraQueryLoggingUtil.getLogger(AbstractRegistryView.class);
                String formatString = addition ? LISTENER_EXCEPTION_ADD : LISTENER_EXCEPTION_REMOVE;
                logger.error((Object)String.format(formatString, listener), (Throwable)ex);
            }
        }
    }
}

