/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ArrayTypeConverter;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtilsCore;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.Messages;

class OverwriteHelper {
    private Object fDestination;
    private IFile[] fFiles = new IFile[0];
    private IFolder[] fFolders = new IFolder[0];
    private ICompilationUnit[] fCus = new ICompilationUnit[0];
    private IPackageFragmentRoot[] fRoots = new IPackageFragmentRoot[0];
    private IPackageFragment[] fPackageFragments = new IPackageFragment[0];

    OverwriteHelper() {
    }

    public void setFiles(IFile[] files) {
        Assert.isNotNull((Object)files);
        this.fFiles = files;
    }

    public void setFolders(IFolder[] folders) {
        Assert.isNotNull((Object)folders);
        this.fFolders = folders;
    }

    public void setCus(ICompilationUnit[] cus) {
        Assert.isNotNull((Object)cus);
        this.fCus = cus;
    }

    public void setPackageFragmentRoots(IPackageFragmentRoot[] roots) {
        Assert.isNotNull((Object)roots);
        this.fRoots = roots;
    }

    public void setPackages(IPackageFragment[] fragments) {
        Assert.isNotNull((Object)fragments);
        this.fPackageFragments = fragments;
    }

    public IFile[] getFilesWithoutUnconfirmedOnes() {
        return this.fFiles;
    }

    public IFolder[] getFoldersWithoutUnconfirmedOnes() {
        return this.fFolders;
    }

    public ICompilationUnit[] getCusWithoutUnconfirmedOnes() {
        return this.fCus;
    }

    public IPackageFragmentRoot[] getPackageFragmentRootsWithoutUnconfirmedOnes() {
        return this.fRoots;
    }

    public IPackageFragment[] getPackagesWithoutUnconfirmedOnes() {
        return this.fPackageFragments;
    }

    public void confirmOverwriting(IReorgQueries reorgQueries, Object destination) {
        Assert.isNotNull((Object)destination);
        Assert.isNotNull((Object)reorgQueries);
        this.fDestination = destination;
        this.confirmOverwritting(reorgQueries);
    }

    private void confirmOverwritting(IReorgQueries reorgQueries) {
        IConfirmQuery overwriteQuery = reorgQueries.createYesYesToAllNoNoToAllQuery(RefactoringCoreMessages.OverwriteHelper_0, true, 6);
        IConfirmQuery skipQuery = reorgQueries.createSkipQuery(RefactoringCoreMessages.OverwriteHelper_2, 7);
        this.confirmFileOverwritting(overwriteQuery, skipQuery);
        this.confirmFolderOverwritting(skipQuery);
        this.confirmCuOverwritting(overwriteQuery);
        this.confirmPackageFragmentRootOverwritting(skipQuery, overwriteQuery);
        this.confirmPackageOverwritting(overwriteQuery);
    }

    private void confirmPackageFragmentRootOverwritting(IConfirmQuery skipQuery, IConfirmQuery overwriteQuery) {
        ArrayList<IPackageFragmentRoot> toNotOverwrite = new ArrayList<IPackageFragmentRoot>(1);
        IPackageFragmentRoot[] iPackageFragmentRootArray = this.fRoots;
        int n = this.fRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (this.canOverwrite(root)) {
                if (root.getResource() instanceof IContainer) {
                    if (!OverwriteHelper.skip(JavaElementLabelsCore.getElementLabel((IJavaElement)root, 0x200009L), skipQuery)) {
                        toNotOverwrite.add(root);
                    }
                } else if (!OverwriteHelper.overwrite(root.getResource(), overwriteQuery)) {
                    toNotOverwrite.add(root);
                }
            }
            ++n2;
        }
        IPackageFragmentRoot[] roots = toNotOverwrite.toArray(new IPackageFragmentRoot[toNotOverwrite.size()]);
        this.fRoots = ArrayTypeConverter.toPackageFragmentRootArray(ReorgUtilsCore.setMinus((IJavaElement[])this.fRoots, (IJavaElement[])roots));
    }

    private void confirmCuOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<ICompilationUnit> cusToNotOverwrite = new ArrayList<ICompilationUnit>(1);
        ICompilationUnit[] iCompilationUnitArray = this.fCus;
        int n = this.fCus.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu = iCompilationUnitArray[n2];
            if (this.canOverwrite(cu) && !OverwriteHelper.overwrite((IJavaElement)cu, overwriteQuery)) {
                cusToNotOverwrite.add(cu);
            }
            ++n2;
        }
        ICompilationUnit[] cus = cusToNotOverwrite.toArray(new ICompilationUnit[cusToNotOverwrite.size()]);
        this.fCus = ArrayTypeConverter.toCuArray(ReorgUtilsCore.setMinus((IJavaElement[])this.fCus, (IJavaElement[])cus));
    }

    private void confirmFolderOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<IFolder> foldersToNotOverwrite = new ArrayList<IFolder>(1);
        IFolder[] iFolderArray = this.fFolders;
        int n = this.fFolders.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder folder = iFolderArray[n2];
            if (this.willOverwrite((IResource)folder) && !OverwriteHelper.skip(BasicElementLabels.getResourceName((IResource)folder), overwriteQuery)) {
                foldersToNotOverwrite.add(folder);
            }
            ++n2;
        }
        IFolder[] folders = foldersToNotOverwrite.toArray(new IFolder[foldersToNotOverwrite.size()]);
        this.fFolders = ArrayTypeConverter.toFolderArray(ReorgUtilsCore.setMinus((IResource[])this.fFolders, (IResource[])folders));
    }

    private void confirmFileOverwritting(IConfirmQuery overwriteQuery, IConfirmQuery skipQuery) {
        ArrayList<IFile> filesToNotOverwrite = new ArrayList<IFile>(1);
        IFile[] iFileArray = this.fFiles;
        int n = this.fFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            if (this.willOverwrite((IResource)file)) {
                IContainer destination = (IContainer)ResourceUtil.getResource(this.fDestination);
                if (ParentChecker.isDescendantOf((IResource)file, destination.findMember(file.getName()))) {
                    if (!OverwriteHelper.skip(BasicElementLabels.getResourceName((IResource)file), skipQuery)) {
                        filesToNotOverwrite.add(file);
                    }
                } else if (!OverwriteHelper.overwrite((IResource)file, overwriteQuery)) {
                    filesToNotOverwrite.add(file);
                }
            }
            ++n2;
        }
        IFile[] files = filesToNotOverwrite.toArray(new IFile[filesToNotOverwrite.size()]);
        this.fFiles = ArrayTypeConverter.toFileArray(ReorgUtilsCore.setMinus((IResource[])this.fFiles, (IResource[])files));
    }

    private void confirmPackageOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<IPackageFragment> toNotOverwrite = new ArrayList<IPackageFragment>(1);
        IPackageFragment[] iPackageFragmentArray = this.fPackageFragments;
        int n = this.fPackageFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragment pack = iPackageFragmentArray[n2];
            if (this.canOverwrite(pack) && !OverwriteHelper.overwrite((IJavaElement)pack, overwriteQuery)) {
                toNotOverwrite.add(pack);
            }
            ++n2;
        }
        IPackageFragment[] packages = toNotOverwrite.toArray(new IPackageFragment[toNotOverwrite.size()]);
        this.fPackageFragments = ArrayTypeConverter.toPackageArray(ReorgUtilsCore.setMinus((IJavaElement[])this.fPackageFragments, (IJavaElement[])packages));
    }

    private boolean canOverwrite(IPackageFragment pack) {
        if (this.fDestination instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot destination = (IPackageFragmentRoot)this.fDestination;
            return !destination.equals(pack.getParent()) && destination.getPackageFragment(pack.getElementName()).exists();
        }
        return this.willOverwrite(pack.getResource());
    }

    private boolean willOverwrite(IResource resource) {
        if (resource == null) {
            return false;
        }
        IResource destinationResource = ResourceUtil.getResource(this.fDestination);
        if (destinationResource.equals((Object)resource.getParent())) {
            return false;
        }
        if (destinationResource instanceof IContainer) {
            IContainer container = (IContainer)destinationResource;
            IResource member = container.findMember(resource.getName());
            return member != null && member.exists();
        }
        return false;
    }

    private boolean canOverwrite(IPackageFragmentRoot root) {
        if (this.fDestination instanceof IJavaProject) {
            IJavaProject destination = (IJavaProject)this.fDestination;
            IFolder conflict = destination.getProject().getFolder(root.getElementName());
            try {
                return !destination.equals(root.getParent()) && conflict.exists() && conflict.members().length > 0;
            }
            catch (CoreException coreException) {
                return true;
            }
        }
        return this.willOverwrite(root.getResource());
    }

    private boolean canOverwrite(ICompilationUnit cu) {
        if (this.fDestination instanceof IPackageFragment) {
            IPackageFragment destination = (IPackageFragment)this.fDestination;
            return !destination.equals(cu.getParent()) && destination.getCompilationUnit(cu.getElementName()).exists();
        }
        return this.willOverwrite(ReorgUtilsCore.getResource((IJavaElement)cu));
    }

    private static boolean overwrite(IResource resource, IConfirmQuery overwriteQuery) {
        return OverwriteHelper.overwrite(BasicElementLabels.getResourceName(resource), overwriteQuery);
    }

    private static boolean overwrite(IJavaElement element, IConfirmQuery overwriteQuery) {
        return OverwriteHelper.overwrite(JavaElementLabelsCore.getElementLabel(element, 0x200009L), overwriteQuery);
    }

    private static boolean overwrite(String name, IConfirmQuery overwriteQuery) {
        String question = Messages.format(RefactoringCoreMessages.OverwriteHelper_1, BasicElementLabels.getJavaElementName(name));
        return overwriteQuery.confirm(question);
    }

    private static boolean skip(String name, IConfirmQuery overwriteQuery) {
        String question = Messages.format(RefactoringCoreMessages.OverwriteHelper_3, BasicElementLabels.getJavaElementName(name));
        return overwriteQuery.confirm(question);
    }
}

