/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.VirtualJoinTable;
import org.eclipse.jpt.jpa.core.context.VirtualJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinTableRelationship;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationArgumentMessages;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class AbstractJavaJoinTableRelationshipStrategy<P extends JavaJoinTableRelationship>
extends AbstractJavaContextModel<P>
implements JavaSpecifiedJoinTableRelationshipStrategy,
JavaSpecifiedJoinTable.ParentAdapter {
    protected JavaSpecifiedJoinTable joinTable;

    protected AbstractJavaJoinTableRelationshipStrategy(P parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        if (this.joinTable != null) {
            this.joinTable.synchronizeWithResourceModel(monitor);
        }
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.updateJoinTable(monitor);
    }

    @Override
    public JavaSpecifiedJoinTable getJoinTable() {
        return this.joinTable;
    }

    protected void setJoinTable(JavaSpecifiedJoinTable joinTable) {
        JavaSpecifiedJoinTable old = this.joinTable;
        this.joinTable = joinTable;
        this.firePropertyChanged("joinTable", old, joinTable);
    }

    protected void updateJoinTable(IProgressMonitor monitor) {
        if (this.buildsJoinTable()) {
            if (this.joinTable == null) {
                this.setJoinTable(this.buildJoinTable());
            } else {
                this.joinTable.update(monitor);
            }
        } else if (this.joinTable != null) {
            this.setJoinTable(null);
        }
    }

    protected boolean buildsJoinTable() {
        return this.getJoinTableAnnotation().isSpecified() || this.getRelationship().mayHaveDefaultJoinTable();
    }

    protected JavaSpecifiedJoinTable buildJoinTable() {
        return this.getJpaFactory().buildJavaJoinTable(this);
    }

    protected abstract JoinTableAnnotation addJoinTableAnnotation();

    protected abstract void removeJoinTableAnnotation();

    @Override
    public JavaJoinTableRelationship getRelationship() {
        return (JavaJoinTableRelationship)this.parent;
    }

    public RelationshipMapping getRelationshipMapping() {
        return this.getRelationship().getMapping();
    }

    @Override
    public void initializeFrom(VirtualJoinTableRelationshipStrategy virtualStrategy) {
        VirtualJoinTable oldTable = virtualStrategy.getJoinTable();
        if (oldTable != null) {
            this.addStrategy();
            this.joinTable.initializeFrom(oldTable);
        }
    }

    @Override
    public String getTableName() {
        return this.joinTable == null ? null : this.joinTable.getName();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        return this.joinTable == null ? null : this.joinTable.getDbTable();
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return ObjectTools.notEquals((Object)this.getTableName(), (Object)tableName);
    }

    @Override
    public String getColumnTableNotValidDescription() {
        return JptJpaCoreValidationArgumentMessages.DOES_NOT_MATCH_JOIN_TABLE;
    }

    @Override
    public String getJoinTableDefaultName() {
        return MappingTools.buildJoinTableDefaultName(this.getRelationship());
    }

    @Override
    public void addStrategy() {
        if (this.joinTable == null) {
            this.addJoinTableAnnotation();
            this.setJoinTable(this.buildJoinTable());
        }
    }

    @Override
    public void removeStrategy() {
        if (this.joinTable != null) {
            if (this.getJoinTableAnnotation().isSpecified()) {
                this.removeJoinTableAnnotation();
            }
            this.setJoinTable(null);
        }
    }

    @Override
    public JavaSpecifiedJoinTableRelationshipStrategy getTableParent() {
        return this;
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.joinTable != null) {
            result = this.joinTable.getCompletionProposals(pos);
        }
        return result;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.joinTable != null) {
            this.joinTable.validate(messages, reporter);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getRelationship().getValidationTextRange();
    }
}

