/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.papyrus.infra.tools.util.Failure;
import org.eclipse.papyrus.infra.tools.util.Success;

public abstract class Try<T>
implements Serializable {
    private static final long serialVersionUID = 2007056722268683220L;
    private static final Try<?> EMPTY = Try.success(null);

    Try() {
    }

    public abstract boolean isSuccess();

    public abstract T get() throws NoSuchElementException;

    public abstract Optional<T> toOptional();

    public final boolean isFailure() {
        return !this.isSuccess();
    }

    public final boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public final boolean isPresent() {
        return this.isSuccess() && !this.isEmpty();
    }

    public abstract String reason();

    public abstract Throwable failure();

    public static <T> Try<T> call(Callable<? extends T> callable) {
        try {
            return Try.success(callable.call());
        }
        catch (Exception e) {
            return Try.failure(e);
        }
    }

    public static <T> Try<T> success(T value) {
        return new Success<T>(value);
    }

    public static <T> Try<T> empty() {
        return EMPTY;
    }

    public static <T> Try<T> failure(Throwable failure) {
        return new Failure(failure);
    }

    public static <T> Try<T> failure(String reason) {
        return new Failure(reason);
    }

    public final void ifSuccess(Consumer<? super T> onSuccess) {
        if (this.isSuccess()) {
            onSuccess.accept(this.get());
        }
    }

    public final void ifPresent(Consumer<? super T> onPresent) {
        if (this.isPresent()) {
            onPresent.accept(this.get());
        }
    }

    public final void ifFailure(BiConsumer<? super String, ? super Throwable> onFailure) {
        if (this.isFailure()) {
            onFailure.accept(this.reason(), this.failure());
        }
    }

    public final void ifFailure(Consumer<? super String> onFailure) {
        this.ifFailure((? super String reason, ? super Throwable __) -> onFailure.accept((String)reason));
    }

    public final T orElse(T failureValue) {
        return this.isSuccess() ? this.get() : failureValue;
    }

    public final T orElseApply(BiFunction<? super String, ? super Throwable, ? extends T> failureFunction) {
        return this.isSuccess() ? this.get() : failureFunction.apply(this.reason(), this.failure());
    }

    public final T orElseApply(Function<? super String, ? extends T> failureFunction) {
        return (T)this.orElseApply((? super String reason, ? super Throwable __) -> failureFunction.apply((String)reason));
    }

    public final T orElseAccept(BiConsumer<? super String, ? super Throwable> onFailure) {
        if (this.isFailure()) {
            onFailure.accept(this.reason(), this.failure());
        }
        return this.orElse(null);
    }

    public final T orElseAccept(Consumer<? super String> onFailure) {
        return this.orElseAccept((? super String reason, ? super Throwable __) -> onFailure.accept((String)reason));
    }

    public abstract <U> Try<U> map(Function<? super T, U> var1);

    public abstract <U> Try<U> flatMap(Function<? super T, Optional<U>> var1);

    public abstract <U> Try<U> tryMap(Function<? super T, Try<U>> var1);

    public abstract Try<T> filter(Predicate<? super T> var1);
}

