/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.papyrus.infra.nattable.handler.AbstractTableHandler;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;

public class ColumnDestroyAxisElementHandler
extends AbstractTableHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IAxisManager axisManager;
        NatEventData eventData = this.getNatEventData();
        if (eventData != null && (axisManager = this.getColumnAxisManager()) != null) {
            axisManager.destroyAxisElement(this.getFullSelectedColumnsIndex(eventData));
        }
        return null;
    }

    @Override
    protected boolean computeEnable(Object evaluationContext) {
        boolean calculatedValue = super.computeEnable(evaluationContext);
        if (calculatedValue) {
            NatEventData eventData = this.getNatEventData();
            IAxisManager axisManager = this.getColumnAxisManager();
            if (eventData == null || axisManager == null) {
                calculatedValue = false;
            } else {
                List<Integer> col = this.getFullSelectedColumnsIndex(eventData);
                calculatedValue = axisManager.canDestroyAxisElement(col);
            }
        }
        return calculatedValue;
    }
}

